/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.bitcoin;

import io.nessus.Wallet;
import io.nessus.bitcoin.BitcoinClientSupport;
import io.nessus.bitcoin.BitcoinWallet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCException;

public class BitcoinAddress
extends BitcoinClientSupport
implements Wallet.Address {
    private final String address;
    private final boolean watchOnly;
    private final List<String> addrLabels = new ArrayList<String>();

    public BitcoinAddress(BitcoinWallet wallet, String address, List<String> labels) {
        super(wallet.client);
        this.address = address;
        this.watchOnly = this.getPrivKey() == null;
        this.addrLabels.addAll(labels);
    }

    public String getPrivKey() {
        String privKey = null;
        try {
            privKey = this.client.dumpPrivKey(this.address);
        }
        catch (BitcoinRPCException bitcoinRPCException) {
            // empty catch block
        }
        return privKey;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isWatchOnly() {
        return this.watchOnly;
    }

    public void addLabels(List<String> labels) {
        for (String label : labels) {
            this.addLabel(label);
        }
    }

    public void addLabel(String label) {
        if (!this.addrLabels.contains(label)) {
            this.addrLabels.add(label);
        }
    }

    public void removeLabel(String label) {
        this.addrLabels.remove(label);
    }

    public List<String> getLabels() {
        return Collections.unmodifiableList(this.addrLabels);
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Wallet.Address)) {
            return false;
        }
        Wallet.Address other = (Wallet.Address)obj;
        return this.address.equals(other.getAddress());
    }

    public String toString() {
        return String.format("[addr=%s, ro=%b, labels=%s]", this.address, this.watchOnly, this.addrLabels);
    }
}

