/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.bitcoin;

import io.nessus.Block;
import io.nessus.Blockchain;
import io.nessus.Network;
import io.nessus.Wallet;
import io.nessus.bitcoin.BitcoinBlock;
import io.nessus.bitcoin.BitcoinClientSupport;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;

public class BitcoinNetwork
extends BitcoinClientSupport
implements Network {
    static final Logger LOG = LoggerFactory.getLogger(BitcoinNetwork.class);
    static final BigDecimal NETWORK_FEE = new BigDecimal("0.001");

    protected BitcoinNetwork(Blockchain blockchain, BitcoindRpcClient client) {
        super(client);
    }

    public BigDecimal estimateFee() {
        return NETWORK_FEE;
    }

    public List<String> generate(int numBlocks) {
        return this.generate(numBlocks, null);
    }

    public List<String> generate(int numBlocks, Wallet.Address address) {
        if (address != null) {
            return this.client.generateToAddress(numBlocks, address.getAddress());
        }
        return this.client.generate(numBlocks);
    }

    public String getBestBlockHash() {
        return this.client.getBestBlockHash();
    }

    public Block getBestBlock() {
        return this.getBlock(this.getBestBlockHash());
    }

    public Block getBlock(String blockHash) {
        return new BitcoinBlock(this.client.getBlock(blockHash));
    }

    public Integer getBlockCount() {
        return this.client.getBlockCount();
    }

    public Integer getBlockRate() {
        return 600;
    }
}

