/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.bitcoin;

import io.nessus.Blockchain;
import io.nessus.Tx;
import io.nessus.TxInput;
import io.nessus.TxOutput;
import io.nessus.UTXO;
import io.nessus.Wallet;
import io.nessus.bitcoin.BitcoinAddress;
import io.nessus.bitcoin.BitcoinBlockchain;
import io.nessus.bitcoin.BitcoinClientSupport;
import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;
import wf.bitcoin.krotjson.HexCoder;

public class BitcoinWallet
extends BitcoinClientSupport
implements Wallet {
    static final Logger LOG = LoggerFactory.getLogger(BitcoinWallet.class);
    private final Set<Wallet.Address> addressses = new LinkedHashSet<Wallet.Address>();
    private final Blockchain blockchain;

    protected BitcoinWallet(BitcoinBlockchain blockchain, BitcoindRpcClient client) {
        super(client);
        this.blockchain = blockchain;
        for (String addr : client.getAddressesByAccount("")) {
            if (!this.isP2PKH(addr)) continue;
            BitcoinAddress aux = new BitcoinAddress(this, addr, Collections.emptyList());
            this.addressses.add(aux);
        }
    }

    public Wallet.Address addPrivateKey(String privKey, List<String> labels) {
        for (Wallet.Address address : this.addressses) {
            if (!privKey.equals(address.getPrivKey())) continue;
            address.addLabels(labels);
            return address;
        }
        this.client.importPrivKey(privKey, "", true);
        String address = null;
        for (String auxAddr : this.client.getAddressesByAccount("")) {
            String auxKey = this.client.dumpPrivKey(auxAddr);
            if (!privKey.equals(auxKey)) continue;
            address = auxAddr;
            break;
        }
        BitcoinAddress bitcoinAddress = new BitcoinAddress(this, address, labels);
        this.addressses.add(bitcoinAddress);
        return bitcoinAddress;
    }

    public Wallet.Address addAddress(String address, List<String> labels) {
        this.client.importAddress(address, "", true);
        BitcoinAddress addr = new BitcoinAddress(this, address, labels);
        this.addressses.add(addr);
        return addr;
    }

    public final Wallet.Address newAddress(List<String> labels) {
        BitcoinAddress addr = this.createNewAddress(labels);
        this.addressses.add(addr);
        return addr;
    }

    protected BitcoinAddress createNewAddress(List<String> labels) {
        String auxAddr = this.assertP2PKH(this.client.getNewAddress("", "legacy"));
        return new BitcoinAddress(this, auxAddr, labels);
    }

    public List<String> getLabels() {
        HashSet labels = new HashSet();
        this.addressses.stream().forEach(a -> labels.addAll(a.getLabels()));
        return labels.stream().sorted().collect(Collectors.toList());
    }

    public Wallet.Address getAddress(String label) {
        List<Wallet.Address> addrs = this.getAddresses(label);
        return addrs != null && addrs.size() > 0 ? addrs.iterator().next() : null;
    }

    public Wallet.Address findAddress(String rawAddr) {
        return this.addressses.stream().filter(a -> a.getAddress().equals(rawAddr)).findFirst().orElse(null);
    }

    public List<Wallet.Address> getAddresses() {
        return this.addressses.stream().collect(Collectors.toList());
    }

    public List<Wallet.Address> getAddresses(String label) {
        AssertArgument.assertNotNull((Object)label, (String)"label");
        List<Wallet.Address> filtered = this.addressses.stream().filter(a -> a.getLabels().contains(label)).collect(Collectors.toList());
        return filtered;
    }

    public Wallet.Address getChangeAddress(String label) {
        List<Wallet.Address> addrs = this.getChangeAddresses(label);
        return addrs != null && addrs.size() > 0 ? addrs.iterator().next() : null;
    }

    public List<Wallet.Address> getChangeAddresses(String label) {
        List<Wallet.Address> filtered = this.addressses.stream().filter(a -> a.getLabels().contains(label)).filter(a -> a.getLabels().contains("_change")).collect(Collectors.toList());
        return filtered;
    }

    public BigDecimal getBalance(String label) {
        return this.getUTXOAmount(this.listUnspent(this.getAddresses(label)));
    }

    public BigDecimal getBalance(Wallet.Address addr) {
        return this.getUTXOAmount(this.listUnspent(Arrays.asList(addr)));
    }

    public String sendToAddress(String toAddress, BigDecimal amount) {
        return this.client.sendToAddress(toAddress, amount);
    }

    public String sendFromLabel(String label, String toAddress, BigDecimal amount) {
        Tx tx;
        BigDecimal estFee = this.blockchain.getNetwork().estimateFee();
        if (amount != ALL_FUNDS) {
            BigDecimal amountPlusFee = amount.add(estFee);
            List<UTXO> utxos = this.selectUnspent(label, amountPlusFee);
            BigDecimal utxosAmount = this.getUTXOAmount(utxos);
            AssertState.assertTrue((Boolean)(amountPlusFee.doubleValue() <= utxosAmount.doubleValue() ? 1 : 0), (String)"Cannot find sufficient funds");
            String changeAddr = this.getChangeAddress(label).getAddress();
            BigDecimal changeAmount = utxosAmount.subtract(amountPlusFee);
            Tx.TxBuilder builder = new Tx.TxBuilder().unspentInputs(utxos).output(toAddress, amount);
            if (0.0 < changeAmount.doubleValue()) {
                builder.output(changeAddr, changeAmount);
            }
            tx = builder.build();
        } else {
            List<UTXO> utxos = this.listUnspent(label);
            BigDecimal utxosAmount = this.getUTXOAmount(utxos);
            BigDecimal sendAmount = utxosAmount.subtract(estFee);
            Tx.TxBuilder builder = new Tx.TxBuilder().unspentInputs(utxos).output(toAddress, sendAmount);
            tx = builder.build();
        }
        String txId = this.sendTx(tx);
        LOG.debug("txId: {}", (Object)txId);
        return txId;
    }

    public String sendTx(Tx tx) {
        String rawTx = this.createRawTx(tx);
        String signedTx = this.signRawTx(rawTx, tx.inputs());
        return this.sendRawTransaction(signedTx);
    }

    public String createRawTx(Tx tx) {
        return this.client.createRawTransaction(this.adaptInputs(tx.inputs()), this.adaptOutputs(tx.outputs()));
    }

    public String signRawTx(String rawTx, List<TxInput> inputs) {
        ArrayList<String> privKeys = new ArrayList<String>();
        for (TxInput txin : inputs) {
            UTXO utxo = (UTXO)txin;
            Wallet.Address addr = this.findAddress(utxo.getAddress());
            String privKey = addr.getPrivKey();
            privKeys.add(privKey);
        }
        return this.client.signRawTransaction(rawTx, this.adaptInputs(inputs), privKeys);
    }

    public String sendRawTransaction(String signedTx) {
        return this.client.sendRawTransaction(signedTx);
    }

    public List<UTXO> listUnspent(String label) {
        return this.listUnspent(this.getAddresses(label));
    }

    public List<UTXO> listUnspent(List<Wallet.Address> addrs) {
        ArrayList<UTXO> result = new ArrayList<UTXO>();
        List<String> rawAddrs = this.getRawAddresses(addrs);
        for (BitcoindRpcClient.Unspent unspnt : this.client.listUnspent(0, Integer.MAX_VALUE, rawAddrs.toArray(new String[addrs.size()]))) {
            String txId = unspnt.txid();
            Integer vout = unspnt.vout();
            String addr = unspnt.address();
            String scriptPubKey = unspnt.scriptPubKey();
            BigDecimal amount = unspnt.amount();
            result.add(new UTXO(txId, vout, scriptPubKey, addr, amount));
        }
        return result;
    }

    public List<UTXO> selectUnspent(String label, BigDecimal amount) {
        List<Wallet.Address> addrs = this.getAddresses(label);
        return this.selectUnspent(addrs, amount);
    }

    public List<UTXO> selectUnspent(List<Wallet.Address> addrs, BigDecimal amount) {
        BigDecimal total = BigDecimal.ZERO;
        ArrayList<UTXO> result = new ArrayList<UTXO>();
        for (UTXO utxo : this.listUnspent(addrs)) {
            result.add(utxo);
            total = total.add(utxo.getAmount());
            if (amount == ALL_FUNDS || amount.compareTo(total) > 0) continue;
            break;
        }
        AssertState.assertTrue((Boolean)(amount.compareTo(total) <= 0 ? 1 : 0), (String)("Insufficient funds: " + total));
        return result;
    }

    public Tx getTransaction(String txId) {
        BitcoindRpcClient.Transaction tx = this.client.getTransaction(txId);
        Tx.TxBuilder builder = new Tx.TxBuilder();
        builder.txId(tx.txId());
        builder.blockHash(tx.blockHash());
        builder.blockTime(tx.blockTime());
        BitcoindRpcClient.RawTransaction rawTx = tx.raw();
        if (rawTx != null) {
            for (BitcoindRpcClient.RawTransaction.In in : rawTx.vIn()) {
                TxInput txIn = new TxInput(in.txid(), in.vout(), in.scriptPubKey());
                builder.input(txIn);
            }
            for (BitcoindRpcClient.RawTransaction.Out out : rawTx.vOut()) {
                BitcoindRpcClient.RawTransaction.Out.ScriptPubKey spk = out.scriptPubKey();
                List addrs = spk.addresses();
                String addr = null;
                if (addrs != null && addrs.size() > 0) {
                    if (addrs.size() > 1) {
                        LOG.warn("Multiple addresses not supported");
                    }
                    addr = (String)addrs.get(0);
                }
                byte[] data = null;
                String hex = spk.hex();
                String type = spk.type();
                byte op = HexCoder.decode((String)hex.substring(0, 2))[0];
                if (op == 106) {
                    data = HexCoder.decode((String)hex);
                }
                TxOutput txOut = new TxOutput(addr, out.value(), data);
                txOut.setType(type);
                builder.output(txOut);
            }
        }
        return builder.build();
    }

    protected boolean isP2PKH(String addr) {
        return addr.startsWith("1") || addr.startsWith("m") || addr.startsWith("n");
    }

    protected String assertP2PKH(String addr) {
        AssertState.assertTrue((Boolean)this.isP2PKH(addr), (String)("Not a P2PKH address: " + addr));
        return addr;
    }

    private List<String> getRawAddresses(List<Wallet.Address> addrs) {
        return addrs.stream().map(a -> a.getAddress()).collect(Collectors.toList());
    }

    private BigDecimal getUTXOAmount(List<UTXO> utxos) {
        BigDecimal result = BigDecimal.ZERO;
        for (UTXO utxo : utxos) {
            result = result.add(utxo.getAmount());
        }
        return result;
    }

    private List<BitcoindRpcClient.TxInput> adaptInputs(List<TxInput> inputs) {
        ArrayList<BitcoindRpcClient.TxInput> result = new ArrayList<BitcoindRpcClient.TxInput>();
        for (TxInput aux : inputs) {
            result.add((BitcoindRpcClient.TxInput)new BitcoindRpcClient.BasicTxInput(aux.getTxId(), aux.getVout(), aux.getScriptPubKey()));
        }
        return result;
    }

    private List<BitcoindRpcClient.TxOutput> adaptOutputs(List<TxOutput> outputs) {
        ArrayList<BitcoindRpcClient.TxOutput> result = new ArrayList<BitcoindRpcClient.TxOutput>();
        for (TxOutput aux : outputs) {
            result.add((BitcoindRpcClient.TxOutput)new BitcoindRpcClient.BasicTxOutput(aux.getAddress(), aux.getAmount(), aux.getData()));
        }
        return result;
    }
}

