/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.bitcoin;

import io.nessus.AbstractNetwork;
import io.nessus.Block;
import io.nessus.Blockchain;
import io.nessus.Network;
import io.nessus.bitcoin.BitcoinBlock;
import java.math.BigDecimal;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;

public class BitcoinNetwork
extends AbstractNetwork
implements Network {
    public BitcoinNetwork(Blockchain blockchain, BitcoindRpcClient client) {
        super(blockchain, client);
    }

    public BigDecimal estimateSmartFee(Integer blocks) {
        blocks = blocks != null ? blocks : 2;
        BigDecimal feeRate = this.client.estimateSmartFee(blocks.intValue()).feeRate();
        feeRate = feeRate != null ? feeRate : new BigDecimal("0.00001");
        return feeRate;
    }

    public BigDecimal getMinTxFee() {
        return new BigDecimal("0.00001500");
    }

    public Integer getBlockRate() {
        return 600;
    }

    public BigDecimal getDustThreshold() {
        return new BigDecimal("0.00000546");
    }

    public BigDecimal getMinDataAmount() {
        return BigDecimal.ZERO;
    }

    public Block getBlock(String blockHash) {
        return new BitcoinBlock(this.client.getBlock(blockHash));
    }
}

