/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.bitcoin;

import io.nessus.AbstractWallet;
import io.nessus.Blockchain;
import io.nessus.Wallet;
import io.nessus.bitcoin.BitcoinAddress;
import io.nessus.bitcoin.BitcoinBlockchain;
import io.nessus.utils.AssertState;
import java.util.List;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;

public class BitcoinWallet
extends AbstractWallet
implements Wallet {
    public BitcoinWallet(BitcoinBlockchain blockchain, BitcoindRpcClient client) {
        super((Blockchain)blockchain, client);
    }

    protected Wallet.Address createNewAddress(List<String> labels) {
        String rawAddr = this.client.getNewAddress(this.concatLabels(labels), "legacy");
        AssertState.assertTrue((Boolean)this.isP2PKH(rawAddr), (String)("Not a P2PKH address: " + rawAddr));
        return this.createAdddressFromRaw(rawAddr, labels);
    }

    protected Wallet.Address createAdddressFromRaw(String rawAddr, List<String> labels) {
        return new BitcoinAddress(this, rawAddr, labels);
    }

    public boolean isP2PKH(String addr) {
        return addr.startsWith("1") || addr.startsWith("m") || addr.startsWith("n");
    }
}

