/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.cipher;

import io.nessus.cipher.utils.DeterministicRandom;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class ECIESCipher {
    public KeyPair generateKeyPair() throws GeneralSecurityException {
        SecureRandom prng = new SecureRandom();
        return this.generateKeyPairInternal(prng);
    }

    public KeyPair generateKeyPair(byte[] seedBytes) throws GeneralSecurityException {
        DeterministicRandom prng = new DeterministicRandom(seedBytes);
        return this.generateKeyPairInternal(prng);
    }

    public byte[] encrypt(PublicKey pubKey, byte[] message) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("ECIES", "BC");
        cipher.init(1, pubKey);
        return cipher.doFinal(message);
    }

    public byte[] decrypt(PrivateKey privKey, byte[] ciphertext) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("ECIES", "BC");
        cipher.init(2, privKey);
        return cipher.doFinal(ciphertext);
    }

    private KeyPair generateKeyPairInternal(SecureRandom prng) throws GeneralSecurityException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", "BC");
        kpg.initialize(new ECGenParameterSpec("secp128r1"), prng);
        return kpg.generateKeyPair();
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

