/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.cipher;

import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import io.nessus.utils.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public class AESCipher {
    private final SecureRandom secureRandom = new SecureRandom();

    public InputStream encrypt(SecretKey secKey, InputStream ins) throws IOException, GeneralSecurityException {
        return this.encrypt(secKey, ins, null);
    }

    public InputStream encrypt(SecretKey secKey, InputStream ins, byte[] addData) throws IOException, GeneralSecurityException {
        byte[] iv = new byte[12];
        this.secureRandom.nextBytes(iv);
        return this.encrypt(secKey, iv, ins, addData);
    }

    public InputStream encrypt(SecretKey secKey, byte[] iv, InputStream input, byte[] addData) throws IOException, GeneralSecurityException {
        AssertArgument.assertNotNull((Object)secKey, (String)"Null secKey");
        AssertArgument.assertNotNull((Object)input, (String)"Null input");
        AssertArgument.assertNotNull((Object)iv, (String)"Null iv");
        AssertArgument.assertTrue((Boolean)(iv.length == 12 ? 1 : 0), (String)"Invalid iv");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)secKey, parameterSpec);
        if (addData != null) {
            cipher.updateAAD(addData);
        }
        CipherInputStream cis = new CipherInputStream(input, cipher);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtils.copyStream((InputStream)cis, (OutputStream)baos);
        byte[] cipherText = baos.toByteArray();
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + iv.length + cipherText.length);
        byteBuffer.putInt(iv.length);
        byteBuffer.put(iv);
        byteBuffer.put(cipherText);
        byte[] result = byteBuffer.array();
        return new ByteArrayInputStream(result);
    }

    public InputStream decrypt(SecretKey secKey, InputStream secretStream) throws IOException, GeneralSecurityException {
        return this.decrypt(secKey, secretStream, null);
    }

    public InputStream decrypt(SecretKey secKey, InputStream secretStream, byte[] addData) throws IOException, GeneralSecurityException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtils.copyStream((InputStream)secretStream, (OutputStream)baos);
        byte[] secretMessage = baos.toByteArray();
        AssertArgument.assertTrue((Boolean)(secretMessage.length > 0 ? 1 : 0), (String)"Secret message cannot be empty");
        ByteBuffer byteBuffer = ByteBuffer.wrap(secretMessage);
        int ivLength = byteBuffer.getInt();
        byte[] iv = new byte[ivLength];
        byteBuffer.get(iv);
        byte[] cipherText = new byte[byteBuffer.remaining()];
        byteBuffer.get(cipherText);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)secKey, new GCMParameterSpec(128, iv));
        if (addData != null) {
            cipher.updateAAD(addData);
        }
        ByteArrayInputStream ins = new ByteArrayInputStream(cipherText);
        CipherInputStream cis = new CipherInputStream(ins, cipher);
        baos = new ByteArrayOutputStream();
        StreamUtils.copyStream((InputStream)cis, (OutputStream)baos);
        byte[] result = baos.toByteArray();
        AssertState.assertTrue((Boolean)(result.length > 0 ? 1 : 0), (String)"Decryption results in empty message");
        return new ByteArrayInputStream(result);
    }
}

