/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.cipher.utils;

import io.ipfs.multihash.Multihash;
import io.nessus.Wallet;
import io.nessus.cipher.utils.DeterministicRandom;
import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Base64;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;

public class AESUtils {
    public static final int DEFAULT_STRENGTH = 128;

    public static SecretKey newSecretKey() throws GeneralSecurityException {
        return AESUtils.generateSecretKeyInternal(null, null, 128);
    }

    public static SecretKey newSecretKey(Wallet.Address addr) throws GeneralSecurityException {
        return AESUtils.generateSecretKeyInternal(addr, null, 128);
    }

    public static SecretKey newSecretKey(Wallet.Address addr, Multihash cid) throws GeneralSecurityException {
        return AESUtils.generateSecretKeyInternal(addr, cid, 128);
    }

    public static SecretKey newSecretKey(Wallet.Address addr, Multihash cid, int strength) throws GeneralSecurityException {
        return AESUtils.generateSecretKeyInternal(addr, cid, strength);
    }

    public static String encodeKey(Key key) {
        byte[] rawKey = key.getEncoded();
        return Base64.getEncoder().encodeToString(rawKey);
    }

    public static SecretKey decodeSecretKey(String encKey) {
        byte[] rawKey = Base64.getDecoder().decode(encKey);
        return AESUtils.decodeSecretKey(rawKey);
    }

    public static SecretKey decodeSecretKey(byte[] rawKey) {
        AssertArgument.assertTrue((Boolean)(rawKey.length == 16 ? 1 : 0), (String)"Expected 128 bit");
        return new SecretKeySpec(rawKey, "AES");
    }

    public static byte[] getIV(Wallet.Address addr, Multihash cid) throws GeneralSecurityException {
        AssertArgument.assertNotNull((Object)addr.getPrivKey(), (String)("Wallet does not control private key for: " + addr));
        byte[] rawSeed = Base64.getDecoder().decode(cid.toBase58() + addr.getPrivKey());
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] sha256 = md.digest(rawSeed);
        AssertState.assertTrue((Boolean)(sha256.length >= 12 ? 1 : 0), (String)("IV seed too short: " + sha256.length));
        return Arrays.copyOf((byte[])sha256, (int)12);
    }

    private static SecretKey generateSecretKeyInternal(Wallet.Address addr, Multihash cid, int strenght) throws GeneralSecurityException {
        AssertArgument.assertTrue((Boolean)(addr == null || addr.getPrivKey() != null ? 1 : 0), (String)("Wallet does not control private key for: " + addr));
        AssertArgument.assertTrue((Boolean)(strenght % 8 == 0 ? 1 : 0), (String)("Invalid stregth: " + strenght));
        SecureRandom secrnd = addr != null && cid != null ? new DeterministicRandom(addr, cid) : (addr != null ? new DeterministicRandom(addr) : new SecureRandom());
        byte[] key = new byte[strenght / 8];
        secrnd.nextBytes(key);
        return new SecretKeySpec(key, "AES");
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

