/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.cipher.utils;

import io.nessus.AbstractAddress;
import io.nessus.Wallet;
import io.nessus.cipher.RSACipher;
import io.nessus.cipher.utils.AESUtils;
import io.nessus.cipher.utils.RSAUtils;
import io.nessus.utils.AssertState;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CipherSanityCheck {
    public static void main(String[] args) throws Exception {
        CipherSanityCheck.verifyPlatform();
    }

    public static void verifyPlatform() throws GeneralSecurityException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] encBytes = AESUtils.newSecretKey().getEncoded();
        String encSecret = Base64.getEncoder().encodeToString(encBytes);
        Wallet.Address auxAddr = CipherSanityCheck.getTestAddress();
        KeyPair keyPair = RSAUtils.newKeyPair(auxAddr);
        PublicKey pubKey = keyPair.getPublic();
        PrivateKey pivKey = keyPair.getPrivate();
        String encPubKey = RSAUtils.encodeKey(pubKey);
        AssertState.assertEquals((Object)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA5SSQgSaIsFYGKxp9uMuwnYi/M1SEx9uq74suJkdbiwUF/Yznz+bu6ZhpimE79lG/g3rn2ptcWXqZ8DcKOucIyCN2JjmRxh5zpRrR9mfV8JYgvYdjLDweUTABidR3w9FkMKrv+1akyz3S/faxy46xl2L10YlC+g3ufLeWrXEjDZckcBJSYSe1KCateAnSSfm/8I733Lr75mBptlPoCdQF5TrfBbkTS7oEcUkk6Mf3ZMpk7Q/QVU7FnK0+JY0kiZruiobSS3WVGCwZaOjKlw/m3PvdW+s/2Ts26Mr1u8HthHk5Bz/GD8SqIfFPvaebYfUpNk6ct8Y6mNNVfKkk+2Fr+QIDAQAB", (Object)encPubKey);
        AssertState.assertEquals((Object)294, (Object)pubKey.getEncoded().length);
        pubKey = RSAUtils.decodePublicKey(encPubKey);
        RSACipher ecipher = new RSACipher();
        byte[] ciphertext = ecipher.encrypt(pubKey, encBytes);
        byte[] decrypted = ecipher.decrypt(pivKey, ciphertext);
        String encResult = Base64.getEncoder().encodeToString(decrypted);
        AssertState.assertEquals((Object)encSecret, (Object)encResult);
    }

    private static Wallet.Address getTestAddress() {
        AbstractAddress addrBob = new AbstractAddress("n3ha6rJa8ZS7B4v4vwNWn8CnLHfUYXW1XE"){

            public String getPrivKey() {
                return "cVfiZLCWbCm3SWoBAToaCoMuYJJjEw5cR6ifuWQY1a5wadXynGC2";
            }
        };
        return addrBob;
    }
}

