/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.cipher.utils;

import io.ipfs.multihash.Multihash;
import io.nessus.Wallet;
import io.nessus.utils.AssertArgument;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import org.bouncycastle.util.Arrays;

public class DeterministicRandom
extends SecureRandom {
    private final MessageDigest md = MessageDigest.getInstance("SHA3-512");
    private byte[] digest;
    private long total;

    public DeterministicRandom(Wallet.Address addr) throws GeneralSecurityException {
        this(addr, null);
    }

    public DeterministicRandom(Wallet.Address addr, Multihash cid) throws GeneralSecurityException {
        AssertArgument.assertNotNull((Object)addr.getPrivKey(), (String)("Wallet does not control private key for: " + addr));
        byte[] bytesA = addr.getPrivKey().getBytes();
        byte[] bytesB = cid != null ? cid.toBytes() : Arrays.reverse((byte[])bytesA);
        this.digest = Arrays.concatenate((byte[])this.md.digest(bytesA), (byte[])this.md.digest(bytesB));
    }

    public DeterministicRandom(byte[] input) throws GeneralSecurityException {
        this.digest = this.md.digest(input);
    }

    @Override
    public void nextBytes(byte[] buffer) {
        if (524288L < this.total) {
            throw new IllegalStateException("Upper limit exceeded");
        }
        int idx = 0;
        byte[] seed = new byte[]{};
        while (seed.length < buffer.length) {
            idx = (idx + 7) % this.digest.length;
            byte[] head = Arrays.copyOfRange((byte[])this.digest, (int)0, (int)idx);
            byte[] tail = Arrays.copyOfRange((byte[])this.digest, (int)idx, (int)this.digest.length);
            this.digest = Arrays.concatenate((byte[])tail, (byte[])head);
            seed = Arrays.concatenate((byte[])seed, (byte[])this.md.digest(this.digest));
        }
        System.arraycopy(seed, 0, buffer, 0, buffer.length);
        this.total += (long)buffer.length;
    }
}

