/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.cipher.utils;

import io.nessus.Wallet;
import io.nessus.cipher.utils.DeterministicRandom;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import java.util.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class ECIESUtils {
    public static KeyPair newKeyPair() throws GeneralSecurityException {
        SecureRandom secrnd = new SecureRandom();
        return ECIESUtils.generateKeyPairInternal(secrnd);
    }

    public static KeyPair newKeyPair(Wallet.Address addr) throws GeneralSecurityException {
        DeterministicRandom secrnd = new DeterministicRandom(addr);
        return ECIESUtils.generateKeyPairInternal(secrnd);
    }

    public static String encodeKey(Key key) {
        byte[] rawKey = key.getEncoded();
        return Base64.getEncoder().encodeToString(rawKey);
    }

    public static PublicKey decodePublicKey(String encKey) {
        byte[] keyBytes = Base64.getDecoder().decode(encKey);
        return ECIESUtils.decodePublicKey(keyBytes);
    }

    static PublicKey decodePublicKey(final byte[] keyBytes) {
        return new PublicKey(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getFormat() {
                return "X.509";
            }

            @Override
            public byte[] getEncoded() {
                return keyBytes;
            }

            @Override
            public String getAlgorithm() {
                return "EC";
            }

            public int hashCode() {
                return Arrays.hashCode(keyBytes);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof PublicKey)) {
                    return false;
                }
                PublicKey other = (PublicKey)obj;
                return Arrays.equals(keyBytes, other.getEncoded());
            }

            public String toString() {
                return Base64.getEncoder().encodeToString(keyBytes);
            }
        };
    }

    private static KeyPair generateKeyPairInternal(SecureRandom secrnd) throws GeneralSecurityException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", "BC");
        kpg.initialize(new ECGenParameterSpec("secp128r1"), secrnd);
        return kpg.generateKeyPair();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

