/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.cipher.utils;

import io.nessus.Wallet;
import io.nessus.cipher.utils.DeterministicRandom;
import io.nessus.utils.AssertArgument;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyPairGeneratorSpi;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSAUtils {
    public static final int DEFAULT_STRENGTH = 2048;

    public static KeyPair newKeyPair() throws GeneralSecurityException {
        return RSAUtils.generateKeyPairInternal(null, 2048);
    }

    public static KeyPair newKeyPair(Wallet.Address addr) throws GeneralSecurityException {
        return RSAUtils.generateKeyPairInternal(addr, 2048);
    }

    public static KeyPair newKeyPair(Wallet.Address addr, int strenght) throws GeneralSecurityException {
        return RSAUtils.generateKeyPairInternal(addr, strenght);
    }

    public static String encodeKey(Key key) {
        byte[] rawKey = key.getEncoded();
        return Base64.getEncoder().encodeToString(rawKey);
    }

    public static PublicKey decodePublicKey(String encKey) throws GeneralSecurityException {
        byte[] keyBytes = Base64.getDecoder().decode(encKey);
        return RSAUtils.decodePublicKey(keyBytes);
    }

    static PublicKey decodePublicKey(byte[] keyBytes) throws GeneralSecurityException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(keySpec);
    }

    private static KeyPair generateKeyPairInternal(Wallet.Address addr, int strenght) throws GeneralSecurityException {
        AssertArgument.assertTrue((Boolean)(addr == null || addr.getPrivKey() != null ? 1 : 0), (String)("Wallet does not control private key for: " + addr));
        SecureRandom secrnd = addr != null ? new DeterministicRandom(addr) : new SecureRandom();
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
        KeyPairGeneratorSpi spi = (KeyPairGeneratorSpi)kpg;
        spi.initialize(strenght, secrnd);
        KeyPair keyPair = kpg.generateKeyPair();
        PublicKey pubKey = RSAUtils.decodePublicKey(RSAUtils.encodeKey(keyPair.getPublic()));
        return new KeyPair(pubKey, keyPair.getPrivate());
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

