/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.common;

import io.nessus.common.Config;
import io.nessus.common.service.BasicLogService;
import io.nessus.common.service.LogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class LogSupport {
    protected final Logger LOG = LoggerFactory.getLogger((String)this.getClass().getName());
    private transient BasicLogService logService;

    protected abstract Config getConfig();

    protected void logError(Throwable th) {
        this.logError(th, null, new Object[0]);
    }

    protected void logError(String msg, Object ... args) {
        this.logError(null, msg, args);
    }

    protected void logError(Throwable th, String msg, Object ... args) {
        this.log(Level.ERROR, th, msg, args);
    }

    protected void logWarn(String msg, Object ... args) {
        this.log(Level.WARN, msg, args);
    }

    protected void logInfo() {
        this.logInfo(" ", new Object[0]);
    }

    protected void logInfo(String msg, Object ... args) {
        this.log(Level.INFO, msg, args);
    }

    protected void logDebug(String msg, Object ... args) {
        this.log(Level.DEBUG, msg, args);
    }

    protected void logTrace(String msg, Object ... args) {
        this.log(Level.TRACE, msg, args);
    }

    protected void log(Level level, String msg, Object ... args) {
        this.log(level, null, msg, args);
    }

    protected void log(Level level, Throwable th, String msg, Object ... args) {
        this.getLogService().log(this.LOG, level, th, msg, args);
    }

    protected boolean isEnabled(Level level) {
        if (level == Level.ERROR) {
            return this.LOG.isErrorEnabled();
        }
        if (level == Level.WARN) {
            return this.LOG.isWarnEnabled();
        }
        if (level == Level.INFO) {
            return this.LOG.isInfoEnabled();
        }
        if (level == Level.DEBUG) {
            return this.LOG.isDebugEnabled();
        }
        return this.LOG.isTraceEnabled();
    }

    private LogService getLogService() {
        if (this.logService == null) {
            this.logService = this.getConfig().getService(BasicLogService.class);
            this.logService.init(this.getConfig());
        }
        return this.logService;
    }
}

