/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.common.main;

import io.nessus.common.BasicConfig;
import io.nessus.common.Config;
import io.nessus.common.ConfigSupport;
import io.nessus.common.main.AbstractOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public abstract class AbstractMain<C extends Config, T extends AbstractOptions>
extends ConfigSupport<C> {
    private static String implVersion;
    private static String implBuild;

    public AbstractMain(URL cfgurl) throws IOException {
        this(new BasicConfig(cfgurl));
    }

    public AbstractMain(C config) {
        super(config);
    }

    protected abstract T createOptions();

    public final void start(String ... args) {
        try {
            this.startInternal(args);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    protected void prepare(T options) throws Exception {
    }

    protected void startInternal(String ... args) throws Exception {
        T options = this.parseArguments(args);
        this.prepare(options);
        this.doStart(options);
    }

    protected abstract void doStart(T var1) throws Exception;

    protected T parseArguments(String ... args) throws CmdLineException {
        String className;
        T options = this.createOptions();
        CmdLineParser parser = new CmdLineParser(options);
        Class<?> clazz = options.getClass();
        String classPath = clazz.getResource(className = clazz.getSimpleName() + ".class").toString();
        if (classPath.startsWith("jar")) {
            String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 2) + "META-INF/MANIFEST.MF";
            try (InputStream ins = new URL(manifestPath).openStream();){
                Manifest manifest = new Manifest(ins);
                Attributes attribs = manifest.getMainAttributes();
                implVersion = attribs.getValue("Implementation-Version");
                implBuild = attribs.getValue("Implementation-Build");
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException ex) {
            this.helpScreen(options);
            throw ex;
        }
        if (((AbstractOptions)options).help) {
            this.helpScreen(options);
            System.exit(0);
        }
        if (((AbstractOptions)options).version) {
            System.out.println(AbstractMain.getVersionString());
            System.exit(0);
        }
        ((AbstractOptions)options).initDefaults((Config)this.getConfig());
        return options;
    }

    public static String getImplVersion() {
        return implVersion;
    }

    public static String getImplBuild() {
        return implBuild;
    }

    public static String getVersionString() {
        if (implVersion != null && implVersion.endsWith("SNAPSHOT")) {
            return String.format("%s (%s)", implVersion, implBuild);
        }
        return String.format("%s (%s)", implVersion, implBuild);
    }

    protected void helpScreen(T options) {
        System.err.println(((AbstractOptions)options).cmd + " [options...]");
        CmdLineParser parser = new CmdLineParser(options);
        parser.printUsage((OutputStream)System.err);
    }
}

