/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.core.ipfs.impl;

import io.ipfs.api.IPFS;
import io.ipfs.api.MerkleNode;
import io.ipfs.api.NamedStreamable;
import io.ipfs.multiaddr.MultiAddress;
import io.ipfs.multihash.Multihash;
import io.nessus.core.ipfs.IPFSClient;
import io.nessus.core.ipfs.IPFSException;
import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import io.nessus.utils.StreamUtils;
import io.nessus.utils.SystemUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIPFSClient
implements IPFSClient {
    static final Logger LOG = LoggerFactory.getLogger(DefaultIPFSClient.class);
    private final MultiAddress addr;
    private final IPFS ipfs;
    private final ExecutorService executorService;

    public DefaultIPFSClient() {
        this(null, null);
    }

    public DefaultIPFSClient(String host, Integer port) {
        String envvar;
        if (host == null) {
            host = envvar = SystemUtils.getenv((String)"IPFS_JSONRPC_ADDR", (String)"127.0.0.1");
        }
        if (port == null) {
            envvar = SystemUtils.getenv((String)"IPFS_JSONRPC_PORT", (String)"5001");
            port = Integer.parseInt(envvar);
        }
        this.addr = new MultiAddress("/ip4/" + host + "/tcp/" + port);
        try {
            this.ipfs = new IPFS(this.addr);
        }
        catch (RuntimeException ex) {
            LOG.error("Cannot connect to: " + this.addr);
            throw ex;
        }
        this.executorService = Executors.newFixedThreadPool(12, new ThreadFactory(){
            AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable run) {
                return new Thread(run, "ipfs-client-" + this.count.incrementAndGet());
            }
        });
    }

    @Override
    public MultiAddress getAPIAddress() {
        return this.addr;
    }

    @Override
    public boolean hasConnection() {
        return this.ipfs != null;
    }

    @Override
    public List<String> add(Path path) throws IOException {
        List parts = this.ipfs().add((NamedStreamable)new NamedStreamable.FileWrapper(path.toFile()));
        return parts.stream().map(mn -> mn.hash.toBase58()).collect(Collectors.toList());
    }

    @Override
    public String addSingle(Path path) throws IOException {
        AssertArgument.assertTrue((Boolean)path.toFile().isFile(), (String)("Not a file: " + path));
        List<String> cids = this.add(path);
        return cids.size() > 0 ? cids.get(0) : null;
    }

    @Override
    public InputStream cat(String hash) throws IOException {
        Multihash mhash = Multihash.fromBase58((String)hash);
        return this.ipfs().catStream(mhash);
    }

    @Override
    public Future<Path> get(final String hash, final Path outdir) {
        Future<Path> future = this.executorService.submit(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                try {
                    Multihash mhash = Multihash.fromBase58((String)hash);
                    return DefaultIPFSClient.this.get(mhash, outdir.resolve(hash));
                }
                catch (Exception ex) {
                    throw new IPFSException(ex);
                }
            }
        });
        return future;
    }

    private Path get(Multihash mhash, Path outpath) throws IOException {
        List links = ((MerkleNode)this.ipfs().ls((Multihash)mhash).get((int)0)).links;
        for (MerkleNode node : links) {
            String name = (String)node.name.get();
            this.get(node.hash, outpath.resolve(name));
        }
        if (links.isEmpty()) {
            File outfile = outpath.toFile();
            outpath.getParent().toFile().mkdirs();
            try (FileOutputStream fout = new FileOutputStream(outfile);){
                InputStream ins = this.ipfs().catStream(mhash);
                StreamUtils.copyStream((InputStream)ins, (OutputStream)fout);
            }
        }
        return outpath;
    }

    @Override
    public String version() throws IOException {
        return this.ipfs().version();
    }

    private IPFS ipfs() {
        AssertState.assertNotNull((Object)this.ipfs, (String)"No IPFS connection");
        return this.ipfs;
    }
}

