/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.core;

import io.ipfs.multihash.Multihash;
import io.nessus.Tx;
import io.nessus.TxOutput;
import io.nessus.UTXO;
import io.nessus.Wallet;
import io.nessus.cipher.utils.RSAUtils;
import io.nessus.ipfs.AHandle;
import io.nessus.ipfs.ContentManagerConfig;
import io.nessus.ipfs.client.IPFSClient;
import io.nessus.ipfs.client.IPFSException;
import io.nessus.ipfs.client.IPFSNotFoundException;
import io.nessus.ipfs.client.IPFSTimeoutException;
import io.nessus.ipfs.core.AbstractHandleManager;
import io.nessus.ipfs.core.DefaultContentManager;
import io.nessus.ipfs.core.FHeaderValues;
import io.nessus.ipfs.core.IPFSCache;
import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AHandleManager
extends AbstractHandleManager<AHandle> {
    private static final String KEY_LABEL = "Label";
    private static final String KEY_ADDRESS = "Address";
    private static final String KEY_PUBKEY = "PublicKey";

    AHandleManager(DefaultContentManager cntmgr) {
        super(cntmgr);
    }

    public AHandle addIpfsContent(AHandle ahandle, boolean dryRun) throws IOException {
        IPFSClient ipfsClient = this.cntmgr.getIPFSClient();
        FHeaderValues fhvals = this.cntmgr.getFHeaderValues();
        Wallet.Address owner = ahandle.getOwner();
        String rawAddr = owner.getAddress();
        PublicKey pubKey = ahandle.getPubKey();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));){
            pw.println(fhvals.PREFIX + "-Version: " + fhvals.VERSION);
            pw.println("Address: " + rawAddr);
            pw.println("Label: " + ahandle.getLabel());
            pw.println("PublicKey: " + RSAUtils.encodeKey((Key)pubKey));
        }
        Multihash cid = ipfsClient.addSingle(baos.toByteArray(), dryRun);
        AHandle ahres = ((AHandle.AHBuilder)new AHandle.AHBuilder(ahandle).cid(cid)).build();
        return ahres;
    }

    public AHandle getIpfsContent(AHandle ahandle, long timeout) throws IOException, GeneralSecurityException {
        AssertArgument.assertNotNull((Object)ahandle, (String)"Null ahandle");
        AssertArgument.assertNotNull((Object)ahandle.getOwner(), (String)"Null owner");
        AssertArgument.assertNotNull((Object)ahandle.getCid(), (String)"Null cid");
        Wallet.Address owner = ahandle.getOwner();
        Multihash cid = ahandle.getCid();
        IPFSCache ipfsCache = this.cntmgr.getIPFSCache();
        AHandle ahres = ipfsCache.get(cid, AHandle.class);
        if (ahres.isAvailable()) {
            return ahres;
        }
        int attempt = ahres.getAttempt();
        this.LOG.info("{}: {}", (Object)this.logPrefix("attempt", attempt), (Object)ahres);
        long before = System.currentTimeMillis();
        try {
            IPFSClient ipfsClient = this.cntmgr.getIPFSClient();
            FHeaderValues fhvals = this.cntmgr.getFHeaderValues();
            Properties props = new Properties();
            Future future = ipfsClient.cat(ahres.getCid());
            InputStream input = (InputStream)future.get(timeout, TimeUnit.MILLISECONDS);
            props.load(input);
            String version = props.getProperty(fhvals.PREFIX + "-Version");
            String rawAddr = props.getProperty(KEY_ADDRESS);
            String encKey = props.getProperty(KEY_PUBKEY);
            AssertState.assertEquals((Object)fhvals.VERSION, (Object)version);
            AssertState.assertEquals((Object)owner.getAddress(), (Object)rawAddr, (String)("Unexpected owner: " + rawAddr));
            PublicKey pubKey = RSAUtils.decodePublicKey((String)encKey);
            ahres = new AHandle.AHBuilder(ahres).pubKey(pubKey).build();
        }
        catch (InterruptedException | ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IPFSException) {
                throw (IPFSException)cause;
            }
            throw new IPFSException((Throwable)ex);
        }
        catch (TimeoutException ex) {
            throw new IPFSTimeoutException((Throwable)ex);
        }
        finally {
            long elapsed = System.currentTimeMillis() - before;
            ahres = ((AHandle.AHBuilder)((AHandle.AHBuilder)new AHandle.AHBuilder(ahres).elapsed(ahres.getElapsed() + elapsed)).attempt(ahres.getAttempt() + 1)).build();
            ipfsCache.put(ahres);
        }
        this.LOG.info("IPFS Addr found: {}", (Object)ahres);
        return ahres;
    }

    public AHandle findContentAsync(Wallet.Address owner, final long timeout) {
        AbstractHandleManager.WorkerFactory<AHandle> factory = new AbstractHandleManager.WorkerFactory<AHandle>(){

            @Override
            public Class<AHandle> getType() {
                return AHandle.class;
            }

            @Override
            public Callable<AHandle> newWorker(AHandle fh) {
                return new AsyncGetCallable(fh, timeout);
            }
        };
        List<AHandle> ahandles = this.findContentAsync(owner, factory, timeout);
        AHandle ahres = ahandles.stream().findFirst().orElse(null);
        return ahres;
    }

    public byte[] createAddrData(Multihash cid) {
        return this.dataHandler.createAddrData(cid);
    }

    @Override
    public AHandle getHandleFromTx(Wallet.Address owner, UTXO utxo) {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        AssertArgument.assertNotNull((Object)utxo, (String)"Null utxo");
        Wallet wallet = this.cntmgr.getBlockchain().getWallet();
        Tx tx = wallet.getTransaction(utxo.getTxId());
        if (!this.isOurs(tx)) {
            return null;
        }
        AHandle ahandle = null;
        List outs = tx.outputs();
        TxOutput out0 = (TxOutput)outs.get(outs.size() - 2);
        TxOutput out1 = (TxOutput)outs.get(outs.size() - 1);
        byte[] txdata = out1.getData();
        Multihash cid = this.dataHandler.extractAddrData(txdata);
        Wallet.Address outAddr = wallet.findAddress(out0.getAddress());
        if (cid != null && outAddr != null) {
            this.LOG.debug("Addr Tx: {} => {}", (Object)tx.txId(), (Object)cid);
            if (!owner.equals(outAddr)) {
                return null;
            }
            ahandle = new AHandle.AHBuilder(owner, tx.txId(), cid).build();
        }
        return ahandle;
    }

    private String logPrefix(String action, int attempt) {
        ContentManagerConfig config = this.cntmgr.getConfig();
        int ipfsAttempts = config.getIpfsAttempts();
        String trdName = Thread.currentThread().getName();
        return String.format("IPFS Addr %s [%s] [%d/%d]", action, trdName, attempt, ipfsAttempts);
    }

    class AsyncGetCallable
    implements Callable<AHandle> {
        final long timeout;
        final AHandle ahandle;

        AsyncGetCallable(AHandle ahandle, long timeout) {
            AssertArgument.assertNotNull((Object)ahandle, (String)"Null ahandle");
            this.timeout = timeout;
            this.ahandle = ahandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AHandle call() throws Exception {
            IPFSCache ipfsCache = AHandleManager.this.cntmgr.getIPFSCache();
            AHandle ahaux = this.ahandle;
            Multihash cid = this.ahandle.getCid();
            try {
                ahaux = AHandleManager.this.getIpfsContent(this.ahandle, this.timeout);
            }
            catch (Exception ex) {
                ahaux = this.processException(cid, ex);
            }
            finally {
                ipfsCache.put(ahaux);
            }
            return ahaux;
        }

        private AHandle processException(Multihash cid, Exception ex) throws InterruptedException {
            IPFSCache ipfsCache = AHandleManager.this.cntmgr.getIPFSCache();
            ContentManagerConfig config = AHandleManager.this.cntmgr.getConfig();
            AHandle ahres = ipfsCache.get(cid, AHandle.class);
            int attempt = ahres.getAttempt();
            if (ex instanceof IPFSTimeoutException) {
                if (config.getIpfsAttempts() <= attempt) {
                    ahres = ((AHandle.AHBuilder)new AHandle.AHBuilder(ahres).expired(true)).build();
                }
                AHandleManager.this.LOG.info("{}: {}", (Object)AHandleManager.this.logPrefix("timeout", attempt), (Object)ahres);
            } else if (ex instanceof IPFSNotFoundException) {
                ahres = ((AHandle.AHBuilder)new AHandle.AHBuilder(ahres).expired(true)).build();
                AHandleManager.this.LOG.warn("{}: {}", (Object)AHandleManager.this.logPrefix("not found", attempt), (Object)ahres);
            } else {
                ahres = ((AHandle.AHBuilder)new AHandle.AHBuilder(ahres).expired(true)).build();
                AHandleManager.this.LOG.error(AHandleManager.this.logPrefix("error", attempt) + ": " + ahres, (Throwable)ex);
            }
            return ahres;
        }
    }
}

