/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.core;

import io.ipfs.multiaddr.MultiAddress;
import io.nessus.Blockchain;
import io.nessus.BlockchainFactory;
import io.nessus.ipfs.client.DefaultIPFSClient;
import io.nessus.ipfs.client.IPFSClient;
import io.nessus.utils.SystemUtils;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.args4j.Option;

public class AbstractConfig {
    public static final String ENV_IPFS_JSONRPC_ADDR = "IPFS_JSONRPC_ADDR";
    public static final String ENV_IPFS_JSONRPC_PORT = "IPFS_JSONRPC_PORT";
    public static final String ENV_IPFS_GATEWAY_ADDR = "IPFS_GATEWAY_ADDR";
    public static final String ENV_IPFS_GATEWAY_PORT = "IPFS_GATEWAY_PORT";
    public static final String ENV_BLOCKCHAIN_JSONRPC_ADDR = "BLOCKCHAIN_JSONRPC_ADDR";
    public static final String ENV_BLOCKCHAIN_JSONRPC_PORT = "BLOCKCHAIN_JSONRPC_PORT";
    public static final String ENV_BLOCKCHAIN_JSONRPC_USER = "BLOCKCHAIN_JSONRPC_USER";
    public static final String ENV_BLOCKCHAIN_JSONRPC_PASS = "BLOCKCHAIN_JSONRPC_PASS";
    public static final String DEFAULT_IPFS_ADDR = "/ip4/127.0.0.1/tcp/5001";
    private static final String DEFAULT_BLOCKCHAIN_IMPL = "io.nessus.bitcoin.BitcoinBlockchain";
    private static final String DEFAULT_BLOCKCHAIN_URL = "http://127.0.0.1:18332";
    private static final String DEFAULT_BLOCKCHAIN_HOST = "127.0.0.1";
    private static final int DEFAULT_BLOCKCHAIN_PORT = 18332;
    private static final String DEFAULT_BLOCKCHAIN_USER = "rpcusr";
    private static final String DEFAULT_BLOCKCHAIN_PASSWORD = "rpcpass";
    @Option(name="--ipfs-api", usage="The IPFS API address")
    String ipfsAddr = "/ip4/127.0.0.1/tcp/5001";
    @Option(name="--bcimpl", usage="The Blockchain implementation class")
    String bcImpl = "io.nessus.bitcoin.BitcoinBlockchain";
    @Option(name="--bcurl", forbids={"--bchost", "--bcport"}, usage="The Blockchain RPC URL")
    String bcUrl = "http://127.0.0.1:18332";
    @Option(name="--bchost", forbids={"--bcurl"}, usage="The Blockchain RPC host")
    String bcHost = "127.0.0.1";
    @Option(name="--bcport", forbids={"--bcurl"}, usage="The Blockchain RPC port")
    int bcPort = 18332;
    @Option(name="--bcuser", usage="The Blockchain RPC user")
    String bcUser = "rpcusr";
    @Option(name="--bcpass", usage="The Blockchain RPC password")
    String bcPass = "rpcpass";
    @Option(name="--help", help=true)
    public boolean help;

    public AbstractConfig() {
    }

    protected AbstractConfig(String ipfsAddr, String bcImpl, String bcUrl, String bcHost, int bcPort, String bcUser, String bcPass) {
        this.ipfsAddr = ipfsAddr;
        this.bcUrl = bcUrl;
        this.bcImpl = bcImpl;
        this.bcHost = bcHost;
        this.bcPort = bcPort;
        this.bcUser = bcUser;
        this.bcPass = bcPass;
    }

    public MultiAddress getIpfsApiAddress() {
        if (DEFAULT_IPFS_ADDR.equals(this.ipfsAddr)) {
            String host = SystemUtils.getenv((String)ENV_IPFS_JSONRPC_ADDR, (String)DEFAULT_BLOCKCHAIN_HOST);
            String port = SystemUtils.getenv((String)ENV_IPFS_JSONRPC_PORT, (String)"5001");
            this.ipfsAddr = String.format("/ip4/%s/tcp/%s", host, port);
        }
        return new MultiAddress(this.ipfsAddr);
    }

    public IPFSClient getIPFSClient() {
        MultiAddress ipfsAddr = this.getIpfsApiAddress();
        DefaultIPFSClient ipfsClient = new DefaultIPFSClient(ipfsAddr);
        return ipfsClient.connect();
    }

    public URL getBlockchainUrl() throws MalformedURLException {
        if (!DEFAULT_BLOCKCHAIN_URL.equals(this.bcUrl)) {
            return new URL(this.bcUrl);
        }
        if (DEFAULT_BLOCKCHAIN_HOST.equals(this.bcHost)) {
            this.bcHost = SystemUtils.getenv((String)ENV_BLOCKCHAIN_JSONRPC_ADDR, (String)this.bcHost);
        }
        if (18332 == this.bcPort) {
            this.bcPort = Integer.parseInt(SystemUtils.getenv((String)ENV_BLOCKCHAIN_JSONRPC_PORT, (String)("" + this.bcPort)));
        }
        if (DEFAULT_BLOCKCHAIN_USER.equals(this.bcUser)) {
            this.bcUser = SystemUtils.getenv((String)ENV_BLOCKCHAIN_JSONRPC_USER, (String)this.bcUser);
        }
        if (DEFAULT_BLOCKCHAIN_PASSWORD.equals(this.bcPass)) {
            this.bcPass = SystemUtils.getenv((String)ENV_BLOCKCHAIN_JSONRPC_PASS, (String)this.bcPass);
        }
        return new URL(String.format("http://%s:%s@%s:%s", this.bcUser, this.bcPass, this.bcHost, this.bcPort));
    }

    public Class<Blockchain> getBlockchainImpl() throws ClassNotFoundException {
        if (DEFAULT_BLOCKCHAIN_IMPL.equals(this.bcImpl)) {
            this.bcImpl = SystemUtils.getenv((String)"BLOCKCHAIN_CLASS_NAME", (String)this.bcImpl);
        }
        ClassLoader loader = AbstractConfig.class.getClassLoader();
        return loader.loadClass(this.bcImpl);
    }

    public Blockchain getBlockchain() {
        Blockchain blockchain;
        try {
            URL bcUrl = this.getBlockchainUrl();
            Class<Blockchain> bcImpl = this.getBlockchainImpl();
            blockchain = BlockchainFactory.getBlockchain((URL)bcUrl, bcImpl);
        }
        catch (ClassNotFoundException | MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
        return blockchain;
    }

    protected static class AbstractConfigBuilder<B extends AbstractConfigBuilder<?, ?>, C extends AbstractConfig> {
        protected String ipfsAddr = "/ip4/127.0.0.1/tcp/5001";
        protected String bcUrl = "http://127.0.0.1:18332";
        protected String bcImpl = "io.nessus.bitcoin.BitcoinBlockchain";
        protected String bcHost = "127.0.0.1";
        protected int bcPort = 18332;
        protected String bcUser = "rpcusr";
        protected String bcPass = "rpcpass";

        protected AbstractConfigBuilder() {
        }

        public B ipfsAddr(String addr) {
            this.ipfsAddr = addr;
            return (B)this;
        }

        public B bcimpl(Class<Blockchain> impl) {
            this.bcImpl = impl.getName();
            return (B)this;
        }

        public B bcurl(URL bcUrl) {
            this.bcUrl = bcUrl.toString();
            return (B)this;
        }

        public B bchost(String bcHost) {
            this.bcHost = bcHost;
            return (B)this;
        }

        public B bcport(int bcPort) {
            this.bcPort = bcPort;
            return (B)this;
        }

        public B bcuser(String bcUser) {
            this.bcUser = bcUser;
            return (B)this;
        }

        public B bcpass(String bcPass) {
            this.bcPass = bcPass;
            return (B)this;
        }
    }
}

