/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.core;

import io.ipfs.multihash.Multihash;
import io.nessus.ipfs.AbstractHandle;
import io.nessus.utils.AssertArgument;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPFSCache {
    static final Logger LOG = LoggerFactory.getLogger(IPFSCache.class);
    private final Map<Multihash, AbstractHandle> cache = Collections.synchronizedMap(new LinkedHashMap());

    public <T extends AbstractHandle> Set<Multihash> keySet(Class<T> type) {
        Set<Object> result = this.cache.keySet();
        if (type == null) {
            return result;
        }
        result = result.stream().filter(k -> type.isAssignableFrom(this.cache.get(k).getClass())).collect(Collectors.toSet());
        return result;
    }

    public void clear() {
        this.cache.clear();
    }

    public <T extends AbstractHandle> List<T> getAll(Class<T> type) {
        return this.cache.values().stream().filter(fh -> type.isAssignableFrom(fh.getClass())).collect(Collectors.toList());
    }

    public <T extends AbstractHandle> T get(Multihash cid, Class<T> type) {
        return (T)this.cache.get(cid);
    }

    public <T extends AbstractHandle> T put(AbstractHandle ahandle) {
        AssertArgument.assertNotNull((Object)ahandle.getOwner(), (String)"Null owner");
        AssertArgument.assertNotNull((Object)ahandle.getCid(), (String)"Null cid");
        AssertArgument.assertNotNull((Object)ahandle.getTxId(), (String)"Null txId");
        LOG.debug("Cache put: {}", (Object)ahandle);
        return (T)this.cache.put(ahandle.getCid(), ahandle);
    }

    public <T extends AbstractHandle> T remove(Multihash cid, Class<T> type) {
        LOG.debug("Cache remove: {}", (Object)cid);
        return (T)this.cache.remove(cid);
    }
}

