/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.jaxrs;

import io.nessus.Blockchain;
import io.nessus.BlockchainFactory;
import io.nessus.RpcClientSupport;
import io.nessus.bitcoin.BitcoinBlockchain;
import io.nessus.core.ipfs.ContentManager;
import io.nessus.core.ipfs.IPFSClient;
import io.nessus.core.ipfs.impl.DefaultContentManager;
import io.nessus.core.ipfs.impl.DefaultIPFSClient;
import io.nessus.ipfs.jaxrs.JAXRSResource;
import io.nessus.ipfs.jaxrs.JAXRSSanityCheck;
import io.nessus.utils.SystemUtils;
import io.undertow.Undertow;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.server.undertow.UndertowJaxrsServer;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.PortProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wf.bitcoin.javabitcoindrpcclient.BitcoinJSONRPCClient;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;

@ApplicationPath(value="/nessus")
public class JAXRSApplication
extends Application {
    private static final Logger LOG = LoggerFactory.getLogger(JAXRSApplication.class);
    static final JAXRSConfig config;
    private static JAXRSApplication INSTANCE;
    private static JAXRSServer jaxrsServer;
    private final ContentManager contentManager;

    public static void main(String[] args) throws Exception {
        JAXRSSanityCheck.verifyPlatform();
        try {
            JAXRSApplication.serverStart();
        }
        catch (Throwable th) {
            LOG.error("Error executing command", th);
            Runtime.getRuntime().exit(1);
        }
    }

    public static JAXRSServer serverStart() throws Exception {
        IPFSClient ipfsClient = JAXRSApplication.ipfsClient();
        LOG.info("IPFS Address: {}", (Object)ipfsClient.getAPIAddress());
        LOG.info("IPFS Version: {}", (Object)ipfsClient.version());
        URL blockchinURL = JAXRSApplication.blockchainURL();
        Class<Blockchain> bcclass = JAXRSApplication.blockchainClass();
        Blockchain blockchain = BlockchainFactory.getBlockchain((URL)blockchinURL, bcclass);
        String networkName = blockchain.getNetwork().getClass().getSimpleName();
        BitcoindRpcClient rpcclient = ((RpcClientSupport)blockchain).getRpcClient();
        LOG.info("{} Version: {}", (Object)networkName, (Object)rpcclient.getNetworkInfo().version());
        Undertow.Builder builder = Undertow.builder().addHttpListener(JAXRSApplication.config.port, JAXRSApplication.config.host);
        UndertowJaxrsServer undertowServer = new UndertowJaxrsServer().start(builder);
        undertowServer.deploy(JAXRSApplication.class);
        jaxrsServer = new JAXRSServer(undertowServer, config);
        LOG.info("Nessus JAXRS: {}", (Object)jaxrsServer.getRootURL());
        return jaxrsServer;
    }

    public static void serverStop() {
        if (jaxrsServer != null) {
            jaxrsServer.stop();
            jaxrsServer = null;
        }
    }

    static JAXRSApplication getInstance() {
        return INSTANCE;
    }

    public JAXRSApplication() {
        ResteasyProviderFactory providerFactory = ResteasyProviderFactory.getInstance();
        providerFactory.registerProvider(GeneralSecurityExceptionMapper.class);
        providerFactory.registerProvider(RuntimeExceptionMapper.class);
        providerFactory.registerProvider(IOExceptionMapper.class);
        Blockchain blockchain = BlockchainFactory.getBlockchain();
        DefaultIPFSClient ipfs = new DefaultIPFSClient();
        this.contentManager = new DefaultContentManager((IPFSClient)ipfs, blockchain);
        INSTANCE = this;
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    public Set<Object> getSingletons() {
        HashSet<Object> singletons = new HashSet<Object>();
        Collections.addAll(singletons, config, this.contentManager);
        return singletons;
    }

    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet();
        classes.add(JAXRSResource.class);
        return classes;
    }

    public static Class<Blockchain> blockchainClass() throws ClassNotFoundException {
        String className = SystemUtils.getenv((String)"BLOCKCHAIN_CLASS_NAME", (String)BitcoinBlockchain.class.getName());
        ClassLoader classLoader = JAXRSApplication.class.getClassLoader();
        return classLoader.loadClass(className);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URL blockchainURL() {
        String rpcaddr = SystemUtils.getenv((String)"BLOCKCHAIN_JSONRPC_ADDR", null);
        String rpcport = SystemUtils.getenv((String)"BLOCKCHAIN_JSONRPC_PORT", null);
        String rpcuser = SystemUtils.getenv((String)"BLOCKCHAIN_JSONRPC_USER", null);
        String rpcpass = SystemUtils.getenv((String)"BLOCKCHAIN_JSONRPC_PASS", null);
        if (rpcaddr == null) return BitcoinJSONRPCClient.DEFAULT_JSONRPC_REGTEST_URL;
        if (rpcport == null) return BitcoinJSONRPCClient.DEFAULT_JSONRPC_REGTEST_URL;
        try {
            URL rpcUrl = new URL(String.format("http://%s:%s", rpcaddr, rpcport));
            String userInfo = rpcUrl.getUserInfo();
            if (userInfo != null) return rpcUrl;
            return new URL(String.format("http://%s:%s@%s:%s", rpcuser, rpcpass, rpcaddr, rpcport));
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static IPFSClient ipfsClient() {
        String rpcaddr = SystemUtils.getenv((String)"IPFS_JSONRPC_ADDR", null);
        String rpcport = SystemUtils.getenv((String)"IPFS_JSONRPC_PORT", null);
        Integer port = rpcport != null ? new Integer(rpcport) : null;
        return new DefaultIPFSClient(rpcaddr, port);
    }

    static {
        String jaxrsAddr = SystemUtils.getenv((String)"NESSUS_JAXRS_ADDR", (String)PortProvider.getHost());
        int jaxrsPort = Integer.parseInt(SystemUtils.getenv((String)"NESSUS_JAXRS_PORT", (String)("" + PortProvider.getPort())));
        config = new JAXRSConfig(jaxrsAddr, jaxrsPort);
    }

    static class AbstractExceptionMapper<T extends Exception>
    implements ExceptionMapper<T> {
        AbstractExceptionMapper() {
        }

        public Response toResponse(T rte) {
            StringWriter strwr = new StringWriter();
            ((Throwable)rte).printStackTrace(new PrintWriter(strwr));
            LOG.error("ERROR executing request", rte);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)strwr.toString()).build();
        }
    }

    @Provider
    public static class RuntimeExceptionMapper
    extends AbstractExceptionMapper<RuntimeException> {
    }

    @Provider
    public static class IOExceptionMapper
    extends AbstractExceptionMapper<IOException> {
    }

    @Provider
    public static class GeneralSecurityExceptionMapper
    extends AbstractExceptionMapper<GeneralSecurityException> {
    }

    public static class JAXRSConfig {
        final String host;
        final int port;

        JAXRSConfig(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            return String.format("http://%s:%d", this.host, this.port);
        }
    }

    public static class JAXRSServer {
        final UndertowJaxrsServer server;
        final JAXRSConfig config;

        JAXRSServer(UndertowJaxrsServer server, JAXRSConfig config) {
            this.server = server;
            this.config = config;
        }

        public URL getRootURL() {
            try {
                return new URL(String.format("http://%s:%d/nessus", this.config.host, this.config.port));
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public JAXRSConfig getJAXRSConfig() {
            return this.config;
        }

        public void stop() {
            this.server.stop();
        }
    }
}

