/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.jaxrs;

import io.nessus.Network;
import io.nessus.ipfs.NessusException;
import io.nessus.ipfs.NessusUserFault;
import io.nessus.ipfs.jaxrs.JAXRSEndpoint;
import io.nessus.ipfs.jaxrs.SAHandle;
import io.nessus.ipfs.jaxrs.SFHandle;
import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCError;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCException;

public class JAXRSClient
implements JAXRSEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(JAXRSClient.class);
    final Client client = ClientBuilder.newClient();
    final URL jaxrsUrl;
    static Long networkVersion;

    public JAXRSClient(URL jaxrsUrl) {
        this.jaxrsUrl = jaxrsUrl;
    }

    public static void logBlogchainNetworkAvailable(Network network) {
        try {
            JAXRSClient.assertBlockchainNetworkAvailable(network);
        }
        catch (BitcoinRPCException bitcoinRPCException) {
            // empty catch block
        }
    }

    public static void assertBlockchainNetworkAvailable(Network network) {
        if (networkVersion == null) {
            try {
                String networkName = network.getClass().getSimpleName();
                networkVersion = network.getNetworkInfo().version();
                LOG.info("{} Version: {}", (Object)networkName, (Object)networkVersion);
            }
            catch (BitcoinRPCException rte) {
                BitcoinRPCError rpcError = rte.getRPCError();
                String errmsg = rpcError != null ? rpcError.getMessage() : rte.getMessage();
                LOG.error("Blockchain not available: {}", (Object)errmsg);
                throw rte;
            }
            catch (RuntimeException rte) {
                LOG.error("Blockchain error", (Throwable)rte);
                throw rte;
            }
        }
    }

    @Override
    public SAHandle registerAddress(String addr) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/regaddr")).queryParam("addr", new Object[]{addr});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        SAHandle ahandle = (SAHandle)res.readEntity(SAHandle.class);
        LOG.info("/regaddr {} => {}", (Object)addr, (Object)ahandle);
        return ahandle;
    }

    @Override
    public List<SAHandle> findAddressInfo(String label, String addr) throws IOException {
        Response res;
        List<Object> shandles;
        WebTarget target = this.client.target(this.generateURL("/addrinfo"));
        if (label != null) {
            target = target.queryParam("label", new Object[]{label});
        }
        if (addr != null) {
            target = target.queryParam("addr", new Object[]{addr});
        }
        if ((shandles = Arrays.asList((Object[])(res = this.processResponse((Response)target.request().get(Response.class))).readEntity(SAHandle[].class))).size() < 2) {
            LOG.info("/addrinfo {} {} => {}", new Object[]{label, addr, shandles});
        } else {
            LOG.info("/addrinfo {} {} => {} addrs", new Object[]{label, addr, shandles.size()});
        }
        return shandles;
    }

    @Override
    public SAHandle unregisterAddress(String addr) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/rmaddr")).queryParam("addr", new Object[]{addr});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        if (Response.Status.NO_CONTENT.getStatusCode() == res.getStatus()) {
            return null;
        }
        SAHandle ahandle = (SAHandle)res.readEntity(SAHandle.class);
        LOG.info("/rmaddr {} => {}", (Object)addr, (Object)ahandle);
        return ahandle;
    }

    @Override
    public SFHandle addIpfsContent(String addr, String relPath, URL srcUrl) throws IOException {
        AssertArgument.assertTrue((Boolean)(relPath != null || srcUrl != null ? 1 : 0), (String)"Path or URL must be given");
        WebTarget target = this.client.target(this.generateURL("/addipfs")).queryParam("addr", new Object[]{addr});
        if (relPath != null) {
            target = target.queryParam("path", new Object[]{relPath});
        }
        if (srcUrl != null) {
            target = target.queryParam("url", new Object[]{srcUrl});
        }
        Response res = this.processResponse((Response)target.request().get(Response.class));
        SFHandle shandle = (SFHandle)res.readEntity(SFHandle.class);
        LOG.info("/addipfs => {}", (Object)shandle.toString(true));
        return shandle;
    }

    @Override
    public SFHandle addIpfsContent(String addr, String relPath, InputStream input) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/addipfs")).queryParam("addr", new Object[]{addr}).queryParam("path", new Object[]{relPath});
        Response res = this.processResponse((Response)target.request().post(Entity.entity((Object)input, (String)"application/octet-stream"), Response.class));
        SFHandle shandle = (SFHandle)res.readEntity(SFHandle.class);
        LOG.info("/addipfs => {}", (Object)shandle);
        return shandle;
    }

    @Override
    public SFHandle getIpfsContent(String addr, String cid, String relPath, Long timeout) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/getipfs")).queryParam("addr", new Object[]{addr}).queryParam("path", new Object[]{relPath}).queryParam("timeout", new Object[]{timeout}).queryParam("cid", new Object[]{cid});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        SFHandle shandle = (SFHandle)res.readEntity(SFHandle.class);
        LOG.info("/getipfs {} => {}", (Object)cid, (Object)shandle.toString(true));
        return shandle;
    }

    @Override
    public SFHandle sendIpfsContent(String addr, String cid, String rawTarget, Long timeout) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/sendipfs")).queryParam("addr", new Object[]{addr}).queryParam("target", new Object[]{rawTarget}).queryParam("cid", new Object[]{cid}).queryParam("timeout", new Object[]{timeout});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        SFHandle shandle = (SFHandle)res.readEntity(SFHandle.class);
        LOG.info("/sendipfs {} => {}", (Object)cid, (Object)shandle.toString(true));
        return shandle;
    }

    @Override
    public List<SFHandle> findIpfsContent(String addr, Long timeout) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/findipfs")).queryParam("addr", new Object[]{addr}).queryParam("timeout", new Object[]{timeout});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        List<Object> shandles = Arrays.asList((Object[])res.readEntity(SFHandle[].class));
        if (shandles.size() < 2) {
            LOG.info("/findipfs {} => {}", (Object)addr, shandles);
        } else {
            LOG.info("/findipfs {} => {} files", (Object)addr, (Object)shandles.size());
        }
        return shandles;
    }

    @Override
    public List<String> unregisterIpfsContent(String addr, List<String> cids) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/rmipfs")).queryParam("addr", new Object[]{addr}).queryParam("cid", cids.toArray());
        Response res = this.processResponse((Response)target.request().get(Response.class));
        List<Object> result = Arrays.asList((Object[])res.readEntity(String[].class));
        LOG.info("/rmipfs {} {} => {}", new Object[]{addr, cids, result});
        return result;
    }

    @Override
    public List<SFHandle> findLocalContent(String addr, String path) throws IOException {
        Response res;
        List<Object> shandles;
        WebTarget target = this.client.target(this.generateURL("/findlocal")).queryParam("addr", new Object[]{addr});
        if (path != null) {
            target = target.queryParam("path", new Object[]{path});
        }
        if ((shandles = Arrays.asList((Object[])(res = this.processResponse((Response)target.request().get(Response.class))).readEntity(SFHandle[].class))).size() < 2) {
            LOG.info("/findlocal {} {} => {}", new Object[]{addr, path, shandles});
        } else {
            LOG.info("/findlocal {} {} => {} files", new Object[]{addr, path, shandles.size()});
        }
        return shandles;
    }

    @Override
    public InputStream getLocalContent(String addr, String path) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/getlocal")).queryParam("addr", new Object[]{addr}).queryParam("path", new Object[]{path});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        InputStream content = (InputStream)res.readEntity(InputStream.class);
        LOG.info("/getlocal {} {}", (Object)addr, (Object)path);
        return content;
    }

    @Override
    public boolean removeLocalContent(String addr, String path) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/rmlocal")).queryParam("addr", new Object[]{addr}).queryParam("path", new Object[]{path});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        Boolean removed = (Boolean)res.readEntity(Boolean.class);
        LOG.info("/rmlocal {} {} => {}", new Object[]{addr, path, removed});
        return removed;
    }

    private Response processResponse(Response res) throws IOException {
        Response.Status status = Response.Status.fromStatusCode((int)res.getStatus());
        if (status == Response.Status.INTERNAL_SERVER_ERROR) {
            String errMessage;
            String errType;
            String stackTrace = (String)res.readEntity(String.class);
            LOG.error(stackTrace);
            String line = new BufferedReader(new StringReader(stackTrace)).readLine();
            int colIdx = line.indexOf(58);
            if (colIdx > 0) {
                errType = line.substring(0, colIdx);
                errMessage = line.substring(colIdx + 2);
            } else {
                errType = line;
                errMessage = "";
            }
            if (NessusUserFault.class.getName().equals(errType)) {
                throw new NessusUserFault(errMessage);
            }
            if (NessusException.class.getName().equals(errType)) {
                throw new NessusException(errMessage);
            }
            if (IOException.class.getName().equals(errType)) {
                throw new IOException(errMessage);
            }
            Throwable errInst = null;
            try {
                ClassLoader loader = JAXRSClient.class.getClassLoader();
                Class<?> extype = loader.loadClass(errType);
                Constructor<?> ctor = extype.getConstructor(String.class);
                errInst = (Throwable)ctor.newInstance(errMessage);
            }
            catch (Exception ex) {
                LOG.error("Cannot load server error: " + line);
            }
            if (errInst instanceof RuntimeException) {
                throw (RuntimeException)errInst;
            }
            if (errInst != null) {
                throw new IllegalStateException(errInst);
            }
            throw new IllegalStateException(errMessage);
        }
        if (status != Response.Status.NO_CONTENT) {
            if (status != Response.Status.OK) {
                LOG.error("{} - {}", (Object)status.getStatusCode(), (Object)status.getReasonPhrase());
            }
            AssertState.assertEquals((Object)Response.Status.OK, (Object)status, (String)status.getReasonPhrase());
        }
        return res;
    }

    private String generateURL(String path) {
        return this.jaxrsUrl + path;
    }
}

