/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.jaxrs;

import io.nessus.cipher.utils.CipherSanityCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAXRSSanityCheck {
    public static void main(String[] args) throws Exception {
        JAXRSSanityCheck.verifyPlatform();
    }

    public static void verifyPlatform() throws Exception {
        JAXRSSanityCheck.verifySLF4J("slf4jA");
        JAXRSSanityCheck.verifyJBossLogging("jblogA");
        CipherSanityCheck.verifyPlatform();
    }

    public static void verifySLF4J(String name) {
        Logger slf4jA = LoggerFactory.getLogger((String)name);
        slf4jA.debug("SLF4J debug - {}", (Object)slf4jA.getName());
    }

    public static void verifyJBossLogging(String name) {
        org.jboss.logging.Logger jblog = org.jboss.logging.Logger.getLogger((String)name);
        jblog.debugf("JBLog debug - %s", (Object)jblog.getName());
    }
}

