/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.jaxrs;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.nessus.ipfs.CidPath;
import io.nessus.ipfs.FHandle;
import io.nessus.utils.AssertArgument;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SFHandle {
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private String cid;
    private String owner;
    private String path;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private String txId;
    private boolean encrypted;
    private boolean available;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private boolean expired;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private int attempt;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private long elapsed;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private List<SFHandle> children = new ArrayList<SFHandle>();

    public SFHandle() {
    }

    public SFHandle(String owner, String cid, String path, boolean available, boolean encrypted) {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        AssertArgument.assertNotNull((Object)path, (String)"Null path");
        this.cid = cid;
        this.path = path;
        this.owner = owner;
        this.available = available;
        this.encrypted = encrypted;
    }

    public SFHandle(FHandle fhandle) {
        AssertArgument.assertNotNull((Object)fhandle, (String)"Null fhandle");
        AssertArgument.assertNotNull((Object)fhandle.getOwner(), (String)"Null owner");
        AssertArgument.assertNotNull((Object)fhandle.getPath(), (String)"Null path");
        Path path = fhandle.getPath();
        CidPath cid = fhandle.getCidPath();
        this.cid = cid != null ? cid.toString() : null;
        this.owner = fhandle.getOwner().getAddress();
        this.path = path != null ? path.toString() : null;
        this.txId = fhandle.getTxId();
        this.encrypted = fhandle.isEncrypted();
        this.available = fhandle.isAvailable();
        this.expired = fhandle.isExpired();
        this.attempt = fhandle.getAttempt();
        this.elapsed = fhandle.getElapsed();
        fhandle.getChildren().forEach(ch -> this.addChild(new SFHandle((FHandle)ch)));
    }

    public String getCid() {
        return this.cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTxId() {
        return this.txId;
    }

    public void setTxId(String txId) {
        this.txId = txId;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public void setAttempt(int attempt) {
        this.attempt = attempt;
    }

    public Long getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(Long elapsed) {
        this.elapsed = elapsed;
    }

    private boolean hasChildren() {
        return this.children.size() > 0;
    }

    public List<SFHandle> getChildren() {
        return this.children;
    }

    public void setChildren(List<SFHandle> children) {
        this.children = children;
    }

    private void addChild(SFHandle child) {
        this.children.add(child);
    }

    public String toString(boolean verbose) {
        if (!verbose) {
            return this.toString();
        }
        StringWriter sw = new StringWriter();
        this.recursiveString(new PrintWriter(sw), 0, this);
        return sw.toString().trim();
    }

    private void recursiveString(PrintWriter pw, int indent, SFHandle fh) {
        char[] pad = new char[indent];
        Arrays.fill(pad, ' ');
        pw.println(new String(pad) + fh);
        if (fh.hasChildren()) {
            fh.children.forEach(ch -> this.recursiveString(pw, indent + 3, (SFHandle)ch));
        }
    }

    public String toString() {
        return String.format("[addr=%s, cid=%s, path=%s, avl=%d, exp=%d, try=%d, time=%s]", this.owner, this.cid, this.path, this.available ? 1 : 0, this.expired ? 1 : 0, this.attempt, this.elapsed);
    }
}

