/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.portal;

import io.nessus.Blockchain;
import io.nessus.Network;
import io.nessus.Wallet;
import io.nessus.ipfs.jaxrs.JAXRSClient;
import io.nessus.ipfs.jaxrs.SFHandle;
import io.nessus.utils.AssertState;
import io.nessus.utils.StreamUtils;
import io.nessus.utils.SystemUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.RedirectHandler;
import io.undertow.util.Headers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCException;

public class NessusContentHandler
implements HttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NessusContentHandler.class);
    final Blockchain blockchain;
    final Network network;
    final Wallet wallet;
    final JAXRSClient client;
    final VelocityEngine ve;
    final URI gatewayURI;
    final ExecutorService executorService;
    private Future<Wallet.Address> lastJob;
    private Long blockchainVersion;

    NessusContentHandler(JAXRSClient client, Blockchain blockchain, URI gatewayURI) {
        this.blockchain = blockchain;
        this.gatewayURI = gatewayURI;
        this.client = client;
        this.network = blockchain.getNetwork();
        this.wallet = blockchain.getWallet();
        this.ve = new VelocityEngine();
        this.ve.setProperty("resource.loader", (Object)"classpath");
        this.ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        this.ve.init();
        this.executorService = Executors.newFixedThreadPool(1, new ThreadFactory(){
            AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable run) {
                return new Thread(run, "webui-pool-" + this.count.incrementAndGet());
            }
        });
    }

    public void handleRequest(HttpServerExchange exchange) {
        ByteBuffer content = null;
        try {
            String path = exchange.getRelativePath();
            content = path.startsWith("/portal") ? this.dynamicContent(exchange) : this.staticContent(exchange);
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            content = ByteBuffer.wrap(sw.toString().getBytes());
            exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, "text/plain");
            LOG.error("Error in: " + exchange.getRequestURI(), (Throwable)ex);
        }
        if (content != null) {
            exchange.getResponseSender().send(content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer dynamicContent(HttpServerExchange exchange) throws Exception {
        String relPath = exchange.getRelativePath();
        if (this.lastJob != null) {
            if (this.lastJob.isDone()) {
                try {
                    Wallet.Address addr = this.lastJob.get();
                    LOG.info("Successfully imported: " + addr);
                }
                finally {
                    this.lastJob = null;
                }
            } else {
                LOG.info("Last import job still running ...");
            }
        }
        String tmplPath = null;
        VelocityContext context = new VelocityContext();
        try {
            this.assertBlockchainAvailable();
        }
        catch (RuntimeException rte) {
            tmplPath = this.pageError(context, rte);
        }
        if (relPath.startsWith("/portal/addtxt")) {
            this.actAddText(exchange, context);
        } else if (relPath.startsWith("/portal/addurl")) {
            this.actAddURL(exchange, context);
        } else if (relPath.startsWith("/portal/assign")) {
            this.actAssignLabel(exchange, context);
        } else if (relPath.startsWith("/portal/rmlocal")) {
            this.actRemoveLocalContent(exchange, context);
        } else if (relPath.startsWith("/portal/fget")) {
            this.actFileGet(exchange, context);
        } else {
            if (relPath.startsWith("/portal/fshow")) {
                return this.actFileShow(exchange, context);
            }
            if (relPath.startsWith("/portal/impkey")) {
                this.actImportKey(exchange, context);
            } else if (relPath.startsWith("/portal/newaddr")) {
                this.actNewAddress(exchange, context);
            } else if (relPath.startsWith("/portal/padd")) {
                tmplPath = this.pageFileAdd(exchange, context);
            } else if (relPath.startsWith("/portal/plist")) {
                tmplPath = this.pageFileList(exchange, context);
            } else if (relPath.startsWith("/portal/pqr")) {
                tmplPath = this.pageQRCode(exchange, context);
            } else if (relPath.startsWith("/portal/psend")) {
                tmplPath = this.pageSend(exchange, context);
            } else if (relPath.startsWith("/portal/regaddr")) {
                this.actRegisterAddress(exchange, context);
            } else if (relPath.startsWith("/portal/sendcid")) {
                this.actSend(exchange, context);
            } else if (relPath.startsWith("/portal/unregaddr")) {
                this.actUnregisterAddress(exchange, context);
            } else if (relPath.startsWith("/portal/rmipfs")) {
                this.actRemoveIPFSContent(exchange, context);
            } else if (tmplPath == null) {
                tmplPath = this.pageHome(context);
            }
        }
        if (tmplPath != null) {
            exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, "text/html");
            try (InputStreamReader reader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(tmplPath));){
                StringWriter strwr = new StringWriter();
                this.ve.evaluate((Context)context, (Writer)strwr, tmplPath, (Reader)reader);
                ByteBuffer byteBuffer = ByteBuffer.wrap(strwr.toString().getBytes());
                return byteBuffer;
            }
        }
        return null;
    }

    private void actAddText(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        String rawAddr = (String)((Deque)qparams.get("addr")).getFirst();
        String relPath = (String)((Deque)qparams.get("path")).getFirst();
        String content = (String)((Deque)qparams.get("content")).getFirst();
        this.client.add(rawAddr, relPath, (InputStream)new ByteArrayInputStream(content.getBytes()));
        this.redirectFileList(exchange, rawAddr);
    }

    private void actAddURL(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        String rawAddr = (String)((Deque)qparams.get("addr")).getFirst();
        String relPath = (String)((Deque)qparams.get("path")).getFirst();
        URL furl = new URL((String)((Deque)qparams.get("url")).getFirst());
        this.client.add(rawAddr, relPath, furl.openStream());
        this.redirectFileList(exchange, rawAddr);
    }

    private void actAssignLabel(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        String rawAddr = (String)((Deque)qparams.get("addr")).getFirst();
        String label = (String)((Deque)qparams.get("label")).getFirst();
        Wallet.Address addr = this.wallet.findAddress(rawAddr);
        addr.setLabels(Arrays.asList(label));
        this.redirectHomePage(exchange);
    }

    private void actFileGet(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        String relPath = (String)((Deque)qparams.get("path")).getFirst();
        String rawAddr = (String)((Deque)qparams.get("addr")).getFirst();
        String cid = (String)((Deque)qparams.get("cid")).getFirst();
        this.client.get(rawAddr, cid, relPath, null);
        this.redirectFileList(exchange, rawAddr);
    }

    private ByteBuffer actFileShow(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        String rawAddr = (String)((Deque)qparams.get("addr")).getFirst();
        String relPath = (String)((Deque)qparams.get("path")).getFirst();
        try (InputStream ins = this.client.getLocalContent(rawAddr, relPath);){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamUtils.copyStream((InputStream)ins, (OutputStream)baos);
            ByteBuffer byteBuffer = ByteBuffer.wrap(baos.toByteArray());
            return byteBuffer;
        }
    }

    private void actImportKey(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        final String key = (String)((Deque)qparams.get("impkey")).getFirst();
        final String label = (String)((Deque)qparams.get("label")).getFirst();
        AssertState.assertTrue((Boolean)(this.lastJob == null || this.lastJob.isDone() ? 1 : 0), (String)"Last import job is not yet done");
        this.lastJob = this.executorService.submit(new Callable<Wallet.Address>(){

            @Override
            public Wallet.Address call() throws Exception {
                if (NessusContentHandler.this.wallet.isP2PKH(key)) {
                    LOG.info("Importing watch only address: {}", (Object)key);
                    return NessusContentHandler.this.wallet.importAddress(key, Arrays.asList(label));
                }
                LOG.info("Importing private key: P**************");
                return NessusContentHandler.this.wallet.importPrivateKey(key, Arrays.asList(label));
            }
        });
        this.redirectHomePage(exchange);
    }

    private void actNewAddress(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        String label = (String)((Deque)qparams.get("label")).getFirst();
        this.wallet.newAddress(label);
        this.redirectHomePage(exchange);
    }

    private void actRegisterAddress(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        String rawAddr = (String)((Deque)qparams.get("addr")).getFirst();
        this.client.registerAddress(rawAddr);
        this.redirectHomePage(exchange);
    }

    private void actRemoveIPFSContent(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        String rawAddr = (String)((Deque)qparams.get("addr")).getFirst();
        Deque deque = (Deque)qparams.get("cids");
        String[] cids = deque.toArray(new String[deque.size()]);
        this.client.removeIPFSContent(rawAddr, Arrays.asList(cids));
        this.redirectFileList(exchange, rawAddr);
    }

    private void actRemoveLocalContent(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        String rawAddr = (String)((Deque)qparams.get("addr")).getFirst();
        String relPath = (String)((Deque)qparams.get("path")).getFirst();
        this.client.removeLocalContent(rawAddr, relPath);
        this.redirectFileList(exchange, rawAddr);
    }

    private void actSend(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        String rawFromAddr = (String)((Deque)qparams.get("fromaddr")).getFirst();
        String rawToAddr = (String)((Deque)qparams.get("toaddr")).getFirst();
        String cid = (String)((Deque)qparams.get("cid")).getFirst();
        this.client.send(rawFromAddr, cid, rawToAddr, null);
        this.redirectFileList(exchange, rawFromAddr);
    }

    private void actUnregisterAddress(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        String rawAddr = (String)((Deque)qparams.get("addr")).getFirst();
        this.client.unregisterAddress(rawAddr);
        this.redirectHomePage(exchange);
    }

    private String pageError(VelocityContext context, RuntimeException rte) {
        String errmsg = rte.getMessage();
        if (rte instanceof BitcoinRPCException) {
            errmsg = ((BitcoinRPCException)rte).getRPCError().getMessage();
            errmsg = "Blockchain not available: " + errmsg;
        }
        context.put("errmsg", (Object)errmsg);
        return "templates/portal-error.vm";
    }

    private String pageFileAdd(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        String rawAddr = (String)((Deque)qparams.get("addr")).getFirst();
        Wallet.Address addr = this.wallet.findAddress(rawAddr);
        AddressDTO paddr = this.portalAddress(addr, true);
        context.put("addr", (Object)paddr);
        return "templates/portal-add.vm";
    }

    private String pageFileList(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        String rawAddr = (String)((Deque)qparams.get("addr")).getFirst();
        Wallet.Address addr = this.wallet.findAddress(rawAddr);
        String pubKey = this.findAddressRegistation(rawAddr);
        AddressDTO paddr = this.portalAddress(addr, pubKey != null);
        context.put("addr", (Object)paddr);
        ArrayList fhandles = new ArrayList(this.client.findIPFSContent(rawAddr, null));
        fhandles.addAll(this.client.findLocalContent(rawAddr));
        context.put("files", fhandles);
        context.put("gatewayUrl", (Object)this.gatewayURI);
        return "templates/portal-list.vm";
    }

    private String pageQRCode(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        String rawAddr = (String)((Deque)qparams.get("addr")).getFirst();
        Wallet.Address addr = this.wallet.findAddress(rawAddr);
        AddressDTO paddr = this.portalAddress(addr, false);
        context.put("addr", (Object)paddr);
        return "templates/portal-qr.vm";
    }

    private String pageSend(HttpServerExchange exchange, VelocityContext context) throws Exception {
        Map qparams = exchange.getQueryParameters();
        String rawAddr = (String)((Deque)qparams.get("addr")).getFirst();
        String relPath = (String)((Deque)qparams.get("path")).getFirst();
        String cid = (String)((Deque)qparams.get("cid")).getFirst();
        Wallet.Address addr = this.wallet.findAddress(rawAddr);
        AddressDTO paddr = this.portalAddress(addr, true);
        ArrayList<AddressDTO> toaddrs = new ArrayList<AddressDTO>();
        for (Wallet.Address aux : this.getAddressWithLabel(true, true)) {
            if (addr.equals(aux)) continue;
            toaddrs.add(this.portalAddress(aux, true));
        }
        context.put("gatewayUrl", (Object)this.gatewayURI);
        context.put("toaddrs", toaddrs);
        context.put("addr", (Object)paddr);
        context.put("file", (Object)new SFHandle(cid, rawAddr, relPath, true, true));
        return "templates/portal-send.vm";
    }

    private String pageHome(VelocityContext context) throws Exception {
        ArrayList<AddressDTO> addrs = new ArrayList<AddressDTO>();
        for (Wallet.Address addr : this.getAddressWithLabel(false, false)) {
            BigDecimal balance = this.wallet.getBalance(addr);
            String pubKey = this.findAddressRegistation(addr.getAddress());
            addrs.add(new AddressDTO(addr, balance, pubKey != null));
        }
        String envLabel = SystemUtils.getenv((String)"NESSUS_WEBUI_LABEL", (String)"Bob");
        context.put("envLabel", (Object)envLabel);
        context.put("addrs", addrs);
        return "templates/portal-home.vm";
    }

    private List<Wallet.Address> getAddressWithLabel(boolean requireLabel, boolean requireRegistered) {
        List<Object> addrs = this.wallet.getAddresses().stream().filter(a -> !a.getLabels().contains("(change)")).filter(a -> !requireLabel || !a.getLabels().isEmpty()).collect(Collectors.toList());
        if (requireRegistered) {
            addrs = addrs.stream().filter(a -> this.findAddressRegistation(a.getAddress()) != null).collect(Collectors.toList());
        }
        return addrs;
    }

    private void redirectHomePage(HttpServerExchange exchange) throws Exception {
        new RedirectHandler("/portal").handleRequest(exchange);
    }

    private void redirectFileList(HttpServerExchange exchange, String rawAddr) throws Exception {
        RedirectHandler handler = new RedirectHandler("/portal/plist?addr=" + rawAddr);
        handler.handleRequest(exchange);
    }

    private AddressDTO portalAddress(Wallet.Address addr, boolean registered) {
        BigDecimal balance = this.wallet.getBalance(addr);
        return new AddressDTO(addr, balance, registered);
    }

    private ByteBuffer staticContent(HttpServerExchange exchange) throws IOException {
        String path = exchange.getRelativePath();
        return this.getResource(path);
    }

    private String findAddressRegistation(String rawAddr) {
        try {
            return this.client.findAddressRegistation(rawAddr);
        }
        catch (IOException ex) {
            LOG.error("Error finding address registration", (Throwable)ex);
            return null;
        }
    }

    private void assertBlockchainAvailable() {
        if (this.blockchainVersion == null) {
            try {
                String networkName = this.network.getClass().getSimpleName();
                this.blockchainVersion = this.network.getNetworkInfo().version();
                LOG.info("{} Version: {}", (Object)networkName, (Object)this.blockchainVersion);
            }
            catch (BitcoinRPCException rte) {
                String errmsg = rte.getRPCError().getMessage();
                LOG.error("Blockchain not available: {}", (Object)errmsg);
                throw rte;
            }
            catch (RuntimeException rte) {
                LOG.error("Blockchain error", (Throwable)rte);
                throw rte;
            }
        }
    }

    private ByteBuffer getResource(String resname) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(resname);
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[256];
        int len = is.read(bytes);
        while (len > 0) {
            baos.write(bytes, 0, len);
            len = is.read(bytes);
        }
        return ByteBuffer.wrap(baos.toByteArray());
    }

    public static class AddressDTO {
        public final Wallet.Address addr;
        public final BigDecimal balance;
        public final boolean registered;

        private AddressDTO(Wallet.Address addr, BigDecimal balance, boolean registered) {
            this.addr = addr;
            this.registered = registered;
            this.balance = balance;
        }

        public String getLabel() {
            List labels = this.addr.getLabels();
            return labels.size() > 0 ? (String)labels.get(0) : "";
        }

        public String getAddress() {
            return this.addr.getAddress();
        }

        public BigDecimal getBalance() {
            return this.balance;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public boolean isWatchOnly() {
            return this.addr.isWatchOnly();
        }

        public String toString() {
            return String.format("[addr=%s, ro=%b, label=%s, reg=%b, bal=%.4f]", this.getAddress(), this.isWatchOnly(), this.getLabel(), this.isRegistered(), this.getBalance());
        }
    }
}

