/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.portal;

import io.nessus.Blockchain;
import io.nessus.BlockchainFactory;
import io.nessus.ipfs.jaxrs.JAXRSApplication;
import io.nessus.ipfs.jaxrs.JAXRSClient;
import io.nessus.ipfs.jaxrs.JAXRSSanityCheck;
import io.nessus.ipfs.portal.NessusContentHandler;
import io.nessus.utils.SystemUtils;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessusWebUI {
    private static final Logger LOG = LoggerFactory.getLogger(NessusWebUI.class);

    public static void main(String[] args) throws Exception {
        JAXRSSanityCheck.verifyPlatform();
        NessusWebUI webUI = new NessusWebUI(args);
        webUI.start();
    }

    public NessusWebUI(String[] args) {
    }

    protected String getApplicationName() {
        return "Nessus";
    }

    protected void start() throws Exception {
        String envHost = SystemUtils.getenv((String)"IPFS_GATEWAY_ADDR", (String)"127.0.0.1");
        String envPort = SystemUtils.getenv((String)"IPFS_GATEWAY_PORT", (String)"8080");
        URI gatewayURI = new URI(String.format("http://%s:%s/ipfs", envHost, envPort));
        LOG.info("IPFS Gateway: {}", (Object)gatewayURI);
        URL rpcUrl = JAXRSApplication.blockchainURL();
        Class bcclass = JAXRSApplication.blockchainClass();
        Blockchain blockchain = BlockchainFactory.getBlockchain((URL)rpcUrl, (Class)bcclass);
        envHost = SystemUtils.getenv((String)"NESSUS_JAXRS_ADDR", (String)"127.0.0.1");
        envPort = SystemUtils.getenv((String)"NESSUS_JAXRS_PORT", (String)"8081");
        URI jaxrsURI = new URI(String.format("http://%s:%s/nessus", envHost, envPort));
        LOG.info("Nessus JAXRS: {}", (Object)jaxrsURI);
        JAXRSClient jaxrsClient = new JAXRSClient(jaxrsURI);
        envHost = SystemUtils.getenv((String)"NESSUS_WEBUI_ADDR", (String)"0.0.0.0");
        envPort = SystemUtils.getenv((String)"NESSUS_WEBUI_PORT", (String)"8082");
        LOG.info("{} WebUI: http://" + envHost + ":" + envPort + "/portal", (Object)this.getApplicationName());
        HttpHandler contentHandler = this.createHttpHandler(gatewayURI, blockchain, jaxrsClient);
        Undertow server = Undertow.builder().addHttpListener(Integer.valueOf(envPort).intValue(), envHost, contentHandler).build();
        server.start();
    }

    protected HttpHandler createHttpHandler(URI gatewayURI, Blockchain blockchain, JAXRSClient jaxrsClient) {
        return new NessusContentHandler(jaxrsClient, blockchain, gatewayURI);
    }
}

