/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.portal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.nessus.ipfs.jaxrs.SFHandle;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TreeData {
    final List<TreeNode> data = new ArrayList<TreeNode>();

    public List<TreeNode> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public TreeData addNode(TreeNode node) {
        this.data.add(node);
        return this;
    }

    public TreeNode lastNode() {
        int size = this.data.size();
        if (size == 0) {
            return null;
        }
        return this.data.get(size - 1);
    }

    public String toString(boolean pretty) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectWriter writer = mapper.writer();
            if (pretty) {
                writer = mapper.writerWithDefaultPrettyPrinter();
            }
            return writer.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public static class TreeNode {
        final String text;
        final Map<String, Object> data = new LinkedHashMap<String, Object>();
        final List<TreeNode> children = new ArrayList<TreeNode>();

        public TreeNode(String text) {
            this.text = text;
        }

        public TreeNode(TreeNode parent, SFHandle sfh) {
            Path path = Paths.get(sfh.getPath(), new String[0]);
            String cid = sfh.getCid();
            this.data.put("addr", sfh.getOwner());
            this.data.put("path", sfh.getPath());
            this.text = parent == null && cid != null ? String.format("%s %s", cid, path) : String.format("%s", path.getFileName());
            if (parent == null || sfh.getChildren().isEmpty()) {
                this.data.put("cid", cid);
            }
        }

        public String getText() {
            return this.text;
        }

        public TreeNode addChild(TreeNode node) {
            this.children.add(node);
            return this;
        }

        public TreeNode lastChild() {
            int size = this.children.size();
            if (size == 0) {
                return null;
            }
            return this.children.get(size - 1);
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public List<TreeNode> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public Map<String, Object> getData() {
            return this.data;
        }
    }
}

