/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.portal;

import io.nessus.ipfs.jaxrs.JAXRSSanityCheck;
import io.nessus.ipfs.portal.ContentHandler;
import io.nessus.ipfs.portal.WebUIConfig;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUI {
    private static final Logger LOG = LoggerFactory.getLogger(WebUI.class);
    private static final String implVersion;
    private static final String implBuild;
    final WebUIConfig config;

    public static void main(String[] args) throws Exception {
        WebUIConfig config = new WebUIConfig();
        CmdLineParser parser = new CmdLineParser((Object)config);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException ex) {
            WebUI.helpScreen(parser);
            throw ex;
        }
        if (config.help) {
            WebUI.helpScreen(parser);
        } else {
            JAXRSSanityCheck.verifyPlatform();
            WebUI webUI = new WebUI(config);
            webUI.start();
        }
    }

    public WebUI(WebUIConfig config) throws Exception {
        this.config = config;
        String buildNumber = WebUI.getImplBuild() != null ? "Build: " + WebUI.getImplBuild() : "";
        LOG.info("{} Version: {} {}", new Object[]{this.getApplicationName(), WebUI.getImplVersion(), buildNumber});
    }

    static String getImplVersion() {
        return implVersion;
    }

    static String getImplBuild() {
        boolean snapshot = implVersion != null && implVersion.endsWith("SNAPSHOT");
        return snapshot ? implBuild : null;
    }

    protected String getApplicationName() {
        return "Nessus";
    }

    protected void start() throws Exception {
        HttpHandler contentHandler = this.createHttpHandler(this.getApplicationName(), this.config);
        Undertow server = Undertow.builder().addHttpListener(this.config.webuiPort, this.config.webuiHost, contentHandler).build();
        server.start();
    }

    protected HttpHandler createHttpHandler(String appName, WebUIConfig config) throws Exception {
        return new ContentHandler(appName, config);
    }

    private static void helpScreen(CmdLineParser parser) {
        System.err.println("run-webui [options...]");
        parser.printUsage((OutputStream)System.err);
    }

    static {
        try (InputStream ins = ContentHandler.class.getResourceAsStream("/META-INF/MANIFEST.MF");){
            Manifest manifest = new Manifest(ins);
            Attributes attribs = manifest.getMainAttributes();
            implVersion = attribs.getValue("Implementation-Version");
            implBuild = attribs.getValue("Implementation-Build");
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

