/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.portal;

import io.nessus.ipfs.core.AbstractConfig;
import io.nessus.utils.SystemUtils;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.args4j.Option;

public final class WebUIConfig
extends AbstractConfig {
    public static final String ENV_NESSUS_WEBUI_ADDR = "NESSUS_WEBUI_ADDR";
    public static final String ENV_NESSUS_WEBUI_PORT = "NESSUS_WEBUI_PORT";
    public static final String ENV_NESSUS_WEBUI_CONTEXT_PATH = "NESSUS_WEBUI_CONTEXT_PATH";
    public static final String ENV_NESSUS_WEBUI_LABEL = "NESSUS_WEBUI_LABEL";
    public static final String DEFAULT_WEBUI_HOST = "0.0.0.0";
    public static final int DEFAULT_WEBUI_PORT = 8082;
    public static final String DEFAULT_WEBUI_CONTEXT_PATH = "portal";
    @Option(name="--jaxrs-host", usage="The Nessus JAXRS host")
    String jaxrsHost = "0.0.0.0";
    @Option(name="--jaxrs-port", usage="The Nessus JAXRS port")
    int jaxrsPort = 8081;
    @Option(name="--jaxrs-path", usage="The JAXRS context path")
    String jaxrsPath = "nessus";
    @Option(name="--webui-host", usage="The WebUI host")
    String webuiHost = "0.0.0.0";
    @Option(name="--webui-port", usage="The WebUI port")
    int webuiPort = 8082;
    @Option(name="--webui-path", usage="The WebUI context path")
    String webuiPath = "portal";

    public WebUIConfig() {
    }

    private WebUIConfig(String ipfsAddr, String bcImpl, String bcUrl, String bcHost, int bcPort, String bcUser, String bcPass, String jaxrsHost, int jaxrsPort, String jaxrsPath, String webuiHost, int webuiPort, String webuiPath) {
        super(ipfsAddr, bcImpl, bcUrl, bcHost, bcPort, bcUser, bcPass);
        this.jaxrsHost = jaxrsHost;
        this.jaxrsPort = jaxrsPort;
        this.jaxrsPath = jaxrsPath;
        this.webuiHost = webuiHost;
        this.webuiPort = webuiPort;
        this.webuiPath = webuiPath;
    }

    public URL getJaxrsUrl() throws MalformedURLException {
        if (DEFAULT_WEBUI_HOST.equals(this.jaxrsHost)) {
            this.jaxrsHost = SystemUtils.getenv((String)"NESSUS_JAXRS_ADDR", (String)this.jaxrsHost);
        }
        if (8081 == this.jaxrsPort) {
            this.jaxrsPort = Integer.parseInt(SystemUtils.getenv((String)"NESSUS_JAXRS_PORT", (String)("" + this.jaxrsPort)));
        }
        if ("nessus" == this.jaxrsPath) {
            this.jaxrsPath = SystemUtils.getenv((String)"NESSUS_JAXRS_CONTEXT_PATH", (String)("" + this.jaxrsPath));
        }
        return new URL(String.format("http://%s:%s/%s", this.jaxrsHost, this.jaxrsPort, this.jaxrsPath));
    }

    public URL getWebUiUrl() throws MalformedURLException {
        if (DEFAULT_WEBUI_HOST.equals(this.webuiHost)) {
            this.webuiHost = SystemUtils.getenv((String)ENV_NESSUS_WEBUI_ADDR, (String)this.webuiHost);
        }
        if (8082 == this.webuiPort) {
            this.webuiPort = Integer.parseInt(SystemUtils.getenv((String)ENV_NESSUS_WEBUI_PORT, (String)("" + this.webuiPort)));
        }
        if (DEFAULT_WEBUI_CONTEXT_PATH == this.webuiPath) {
            this.webuiPath = SystemUtils.getenv((String)ENV_NESSUS_WEBUI_CONTEXT_PATH, (String)("" + this.webuiPath));
        }
        return new URL(String.format("http://%s:%s/%s", this.webuiHost, this.webuiPort, this.webuiPath));
    }

    public static class WebUIConfigBuilder
    extends AbstractConfig.AbstractConfigBuilder<WebUIConfigBuilder, WebUIConfig> {
        String jaxrsPath = "nessus";
        String jaxrsHost = "0.0.0.0";
        int jaxrsPort = 8081;
        String webuiHost = "0.0.0.0";
        int webuiPort = 8082;
        String webuiPath = "portal";

        public WebUIConfigBuilder jaxrsHost(String jaxrsHost) {
            this.jaxrsHost = jaxrsHost;
            return this;
        }

        public WebUIConfigBuilder jaxrsPort(int jaxrsPort) {
            this.jaxrsPort = jaxrsPort;
            return this;
        }

        public WebUIConfigBuilder jaxrsPath(String jaxrsPath) {
            this.jaxrsPath = jaxrsPath;
            return this;
        }

        public WebUIConfigBuilder webuiHost(String webuiHost) {
            this.webuiHost = webuiHost;
            return this;
        }

        public WebUIConfigBuilder webuiPort(int webuiPort) {
            this.webuiPort = webuiPort;
            return this;
        }

        public WebUIConfigBuilder webuiPath(String webuiPath) {
            this.webuiPath = webuiPath;
            return this;
        }

        public WebUIConfig build() {
            return new WebUIConfig(this.ipfsAddr, this.bcImpl, this.bcUrl, this.bcHost, this.bcPort, this.bcUser, this.bcPass, this.jaxrsHost, this.jaxrsPort, this.jaxrsPath, this.webuiHost, this.webuiPort, this.webuiPath);
        }
    }
}

