/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs;

import io.nessus.cmd.CmdLineClient;
import io.nessus.ipfs.IPFSClient;
import io.nessus.utils.AssertState;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleIPFSClient
extends CmdLineClient
implements IPFSClient {
    static final Logger LOG = LoggerFactory.getLogger(SimpleIPFSClient.class);
    final String[] opts;

    public SimpleIPFSClient() {
        String host = System.getenv("IPFS_API_HOST");
        if (host != null) {
            String port = System.getenv("IPFS_API_PORT");
            port = port != null ? port : "5001";
            this.opts = new String[]{String.format("--api=/ip4/%s/tcp/%s", host, port)};
        } else {
            this.opts = null;
        }
    }

    @Override
    public String add(Path path) {
        String res = this.exec(this.concat("add", new Object[]{path}));
        String[] toks = this.split(res);
        AssertState.assertEquals((Object)"added", (Object)toks[0]);
        return toks[1];
    }

    @Override
    public String cat(String cid) {
        return this.exec(this.concat("cat", new Object[]{cid}));
    }

    @Override
    public String get(String cid, Path outdir) {
        return this.exec(this.concat("get", new Object[]{"-o " + outdir, cid}));
    }

    @Override
    public String get(String cid, Path outdir, Long timeout, TimeUnit unit) {
        return this.exec(this.concat("get", new Object[]{"-o " + outdir, cid}), timeout, unit);
    }

    @Override
    public String version() {
        return this.exec(this.concat("version", null));
    }

    private String concat(String cmd, Object[] args) {
        StringBuffer line = new StringBuffer("ipfs");
        for (String opt : this.opts != null ? this.opts : new String[]{}) {
            line.append(" " + opt);
        }
        line.append(" " + cmd);
        for (Object arg : args != null ? args : new String[]{}) {
            line.append(" " + arg);
        }
        return line.toString();
    }

    private String[] split(String result) {
        return result.split(" ");
    }
}

