/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.utils;

import java.util.Date;

public final class TimeUtils {
    private TimeUtils() {
    }

    public static Long elapsedTime(Date startTime) {
        return TimeUtils.elapsedTime(startTime, new Date());
    }

    public static Long elapsedTime(Date startTime, Date endTime) {
        return endTime.getTime() - startTime.getTime();
    }

    public static String elapsedTimeString(Date startTime) {
        Long elapsed = TimeUtils.elapsedTime(startTime, new Date());
        return TimeUtils.elapsedTimeString(elapsed);
    }

    public static String elapsedTimeString(Long millis) {
        long hours = millis / 3600000L;
        long mins = millis % 3600000L / 60000L;
        long secs = millis % 60000L / 1000L;
        long mills = millis % 1000L;
        return String.format("%02d:%02d:%02d:%03d", hours, mins, secs, mills);
    }
}

