/*-
 * #%L
 * Nessus :: Weka :: API
 * %%
 * Copyright (C) 2020 Nessus
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package io.nessus.weka;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;

import weka.classifiers.Classifier;

public class ModelLoader implements Supplier<Classifier> {

    private final Path inpath;
    
    public ModelLoader(String inpath) {
        this(Paths.get(inpath));
    }

    public ModelLoader(Path inpath) {
        this.inpath = inpath;
    }

    @Override
    public Classifier get() {
        try (InputStream instream = new FileInputStream(inpath.toFile())) {
            return (Classifier) new ObjectInputStream(instream).readObject();
        } catch (IOException | ClassNotFoundException ex) {
            throw UncheckedException.create(ex);
        }
   }
}
