/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.http.multipart;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.handler.codec.http.DefaultLastHttpContent;
import io.netty5.handler.codec.http.EmptyLastHttpContent;
import io.netty5.util.AsciiString;
import io.netty5.util.Resource;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Helpers {
    static Buffer copiedBuffer(String str, Charset charset) {
        return DefaultBufferAllocators.onHeapAllocator().copyOf(str, charset);
    }

    static Buffer copiedBuffer(byte[] bytes, int offset, int length) {
        Buffer buf = DefaultBufferAllocators.onHeapAllocator().allocate(length);
        buf.writeBytes(bytes, offset, length);
        return buf;
    }

    static Buffer copiedBuffer(byte[] bytes) {
        Buffer buf = DefaultBufferAllocators.onHeapAllocator().allocate(bytes.length);
        buf.writeBytes(bytes);
        return buf;
    }

    static Buffer toComposite(Buffer ... bufs) {
        return DefaultBufferAllocators.onHeapAllocator().compose((Iterable)Stream.of(bufs).map(Resource::send).collect(Collectors.toList()));
    }

    static EmptyLastHttpContent emptyLastHttpContent() {
        return new EmptyLastHttpContent(DefaultBufferAllocators.preferredAllocator());
    }

    static DefaultLastHttpContent defaultLastHttpContent() {
        return new DefaultLastHttpContent(DefaultBufferAllocators.preferredAllocator().allocate(0));
    }

    static String toString(Buffer buf, int offset, int length, Charset charset) {
        byte[] bytes = new byte[length];
        buf.copyInto(offset, bytes, 0, length);
        if (StandardCharsets.US_ASCII.equals(charset)) {
            return new AsciiString(bytes).toString();
        }
        return new String(bytes, 0, length, charset);
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T, X extends Exception> {
        public void accept(T var1) throws X;

        default public ThrowingConsumer<T, X> andThen(ThrowingConsumer<? super T, X> after) {
            Objects.requireNonNull(after);
            return t -> {
                this.accept(t);
                after.accept(t);
            };
        }
    }
}

