/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.http.multipart;

import io.netty.contrib.handler.codec.http.multipart.Helpers;
import io.netty.contrib.handler.codec.http.multipart.HttpData;
import io.netty.contrib.handler.codec.http.multipart.InterfaceHttpData;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.buffer.Drop;
import io.netty5.buffer.Owned;
import io.netty5.buffer.internal.ResourceSupport;
import io.netty5.util.Resource;
import io.netty5.util.internal.ObjectUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

final class InternalAttribute
extends ResourceSupport<HttpData, InternalAttribute>
implements InterfaceHttpData {
    private List<Buffer> value;
    private final Charset charset;
    private int size;
    private static final Drop<InternalAttribute> drop = new Drop<InternalAttribute>(){

        public void drop(InternalAttribute data) {
        }

        public Drop<InternalAttribute> fork() {
            return this;
        }

        public void attach(InternalAttribute mixedFileUpload) {
        }
    };

    InternalAttribute(Charset charset) {
        super(drop);
        this.charset = charset;
        this.value = new ArrayList<Buffer>();
    }

    @Override
    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return InterfaceHttpData.HttpDataType.InternalAttribute;
    }

    public void addValue(String value) {
        ObjectUtil.checkNotNullWithIAE((Object)value, (String)"value");
        Buffer buf = Helpers.copiedBuffer(value, this.charset);
        this.value.add(buf);
        this.size += buf.readableBytes();
    }

    public void addValue(String value, int rank) {
        ObjectUtil.checkNotNullWithIAE((Object)value, (String)"value");
        Buffer buf = Helpers.copiedBuffer(value, this.charset);
        this.value.add(rank, buf);
        this.size += buf.readableBytes();
    }

    public void setValue(String value, int rank) {
        ObjectUtil.checkNotNullWithIAE((Object)value, (String)"value");
        Buffer buf = Helpers.copiedBuffer(value, this.charset);
        Buffer old = this.value.set(rank, buf);
        if (old != null) {
            this.size -= old.readableBytes();
            old.close();
        }
        this.size += buf.readableBytes();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof InternalAttribute)) {
            return false;
        }
        InternalAttribute attribute = (InternalAttribute)o;
        return this.getName().equalsIgnoreCase(attribute.getName());
    }

    @Override
    public int compareTo(InterfaceHttpData o) {
        if (!(o instanceof InternalAttribute)) {
            throw new ClassCastException("Cannot compare " + this.getHttpDataType() + " with " + o.getHttpDataType());
        }
        return this.compareTo((InternalAttribute)o);
    }

    @Override
    public int compareTo(InternalAttribute o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Buffer elt : this.value) {
            result.append(elt.toString(this.charset));
        }
        return result.toString();
    }

    public int size() {
        return this.size;
    }

    public Buffer toBuffer() {
        return DefaultBufferAllocators.onHeapAllocator().compose((Iterable)this.value.stream().map(Resource::send).collect(Collectors.toList()));
    }

    @Override
    public String getName() {
        return "InternalAttribute";
    }

    protected RuntimeException createResourceClosedException() {
        return new RuntimeException("Resource closed");
    }

    protected Owned<InternalAttribute> prepareSend() {
        return drop -> {
            InternalAttribute copy = new InternalAttribute(this.charset);
            copy.value = this.value;
            copy.size = this.size;
            this.value = Collections.emptyList();
            this.size = 0;
            return copy;
        };
    }
}

