/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.http.multipart;

import io.netty.contrib.handler.codec.http.multipart.AbstractMixedHttpData;
import io.netty.contrib.handler.codec.http.multipart.Attribute;
import io.netty.contrib.handler.codec.http.multipart.DiskAttribute;
import io.netty.contrib.handler.codec.http.multipart.DiskFileUpload;
import io.netty.contrib.handler.codec.http.multipart.MemoryAttribute;
import io.netty5.buffer.Owned;
import io.netty5.handler.codec.http.HttpConstants;
import io.netty5.util.Send;
import java.io.IOException;
import java.nio.charset.Charset;

public class MixedAttribute
extends AbstractMixedHttpData<Attribute>
implements Attribute {
    public MixedAttribute(String name, long limitSize) {
        this(name, limitSize, HttpConstants.DEFAULT_CHARSET);
    }

    public MixedAttribute(String name, long definedSize, long limitSize) {
        this(name, definedSize, limitSize, HttpConstants.DEFAULT_CHARSET);
    }

    public MixedAttribute(String name, long limitSize, Charset charset) {
        this(name, limitSize, charset, DiskAttribute.baseDirectory, DiskAttribute.deleteOnExitTemporaryFile);
    }

    public MixedAttribute(String name, long limitSize, Charset charset, String baseDir, boolean deleteOnExit) {
        this(name, 0L, limitSize, charset, baseDir, deleteOnExit);
    }

    public MixedAttribute(String name, long definedSize, long limitSize, Charset charset) {
        this(name, definedSize, limitSize, charset, DiskAttribute.baseDirectory, DiskAttribute.deleteOnExitTemporaryFile);
    }

    public MixedAttribute(String name, long definedSize, long limitSize, Charset charset, String baseDir, boolean deleteOnExit) {
        super(limitSize, baseDir, deleteOnExit, new MemoryAttribute(name, definedSize, charset));
    }

    public MixedAttribute(String name, String value, long limitSize) {
        this(name, value, limitSize, HttpConstants.DEFAULT_CHARSET, DiskAttribute.baseDirectory, DiskFileUpload.deleteOnExitTemporaryFile);
    }

    public MixedAttribute(String name, String value, long limitSize, Charset charset) {
        this(name, value, limitSize, charset, DiskAttribute.baseDirectory, DiskFileUpload.deleteOnExitTemporaryFile);
    }

    private static Attribute makeInitialAttributeFromValue(String name, String value, long limitSize, Charset charset, String baseDir, boolean deleteOnExit) {
        if ((long)value.length() > limitSize) {
            try {
                return new DiskAttribute(name, value, charset, baseDir, deleteOnExit);
            }
            catch (IOException e) {
                try {
                    return new MemoryAttribute(name, value, charset);
                }
                catch (IOException ignore) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        try {
            return new MemoryAttribute(name, value, charset);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public MixedAttribute(String name, String value, long limitSize, Charset charset, String baseDir, boolean deleteOnExit) {
        super(limitSize, baseDir, deleteOnExit, MixedAttribute.makeInitialAttributeFromValue(name, value, limitSize, charset, baseDir, deleteOnExit));
    }

    public MixedAttribute(String baseDir, boolean deleteOnExit, long limitSize, Attribute attribute) {
        super(limitSize, baseDir, deleteOnExit, attribute);
    }

    @Override
    public String getValue() throws IOException {
        return ((Attribute)this.wrapped).getValue();
    }

    @Override
    public void setValue(String value) throws IOException {
        ((Attribute)this.wrapped).setValue(value);
    }

    @Override
    Attribute makeDiskData() {
        DiskAttribute diskAttribute = new DiskAttribute(this.getName(), this.definedLength(), this.baseDir, this.deleteOnExit);
        diskAttribute.setMaxSize(this.getMaxSize());
        return diskAttribute;
    }

    protected Owned<AbstractMixedHttpData<?>> prepareSend() {
        Send send = ((Attribute)this.wrapped).send();
        return drop -> {
            Attribute receivedAttr = (Attribute)send.receive();
            MixedAttribute copy = new MixedAttribute(this.baseDir, this.deleteOnExit, this.limitSize, receivedAttr);
            return copy;
        };
    }
}

