/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socks;

import io.netty.contrib.handler.codec.socks.SocksRequest;
import io.netty.contrib.handler.codec.socks.SocksRequestType;
import io.netty.contrib.handler.codec.socks.SocksSubnegotiationVersion;
import io.netty5.buffer.api.Buffer;
import io.netty5.util.CharsetUtil;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Objects;

public final class SocksAuthRequest
extends SocksRequest {
    private static final SocksSubnegotiationVersion SUBNEGOTIATION_VERSION = SocksSubnegotiationVersion.AUTH_PASSWORD;
    private final String username;
    private final String password;

    public SocksAuthRequest(String username, String password) {
        super(SocksRequestType.AUTH);
        Objects.requireNonNull(username, "username");
        Objects.requireNonNull(password, "password");
        CharsetEncoder asciiEncoder = CharsetUtil.encoder((Charset)CharsetUtil.US_ASCII);
        if (!asciiEncoder.canEncode(username) || !asciiEncoder.canEncode(password)) {
            throw new IllegalArgumentException("username: " + username + " or password: **** values should be in pure ascii");
        }
        if (username.length() > 255) {
            throw new IllegalArgumentException("username: " + username + " exceeds 255 char limit");
        }
        if (password.length() > 255) {
            throw new IllegalArgumentException("password: **** exceeds 255 char limit");
        }
        this.username = username;
        this.password = password;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    @Override
    public void encodeAsBuffer(Buffer buffer) {
        buffer.writeByte(SUBNEGOTIATION_VERSION.byteValue());
        buffer.writeByte((byte)this.username.length());
        buffer.writeCharSequence((CharSequence)this.username, CharsetUtil.US_ASCII);
        buffer.writeByte((byte)this.password.length());
        buffer.writeCharSequence((CharSequence)this.password, CharsetUtil.US_ASCII);
    }
}

