/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socks;

import io.netty.contrib.handler.codec.socks.SocksAuthRequest;
import io.netty.contrib.handler.codec.socks.SocksCommonUtils;
import io.netty.contrib.handler.codec.socks.SocksSubnegotiationVersion;
import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.util.CharsetUtil;

public class SocksAuthRequestDecoder
extends ByteToMessageDecoder {
    private State state = State.CHECK_PROTOCOL_VERSION;
    private String username;

    protected void decode(ChannelHandlerContext ctx, Buffer buffer) throws Exception {
        switch (this.state) {
            case CHECK_PROTOCOL_VERSION: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                if (buffer.readByte() != SocksSubnegotiationVersion.AUTH_PASSWORD.byteValue()) {
                    ctx.fireChannelRead((Object)SocksCommonUtils.UNKNOWN_SOCKS_REQUEST);
                    break;
                }
                this.state = State.READ_USERNAME;
            }
            case READ_USERNAME: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                byte fieldLength = buffer.getByte(buffer.readerOffset());
                if (buffer.readableBytes() < 1 + fieldLength) {
                    return;
                }
                buffer.skipReadableBytes(1);
                this.username = buffer.readCharSequence((int)fieldLength, CharsetUtil.US_ASCII).toString();
                this.state = State.READ_PASSWORD;
            }
            case READ_PASSWORD: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                byte fieldLength = buffer.getByte(buffer.readerOffset());
                if (buffer.readableBytes() < 1 + fieldLength) {
                    return;
                }
                buffer.skipReadableBytes(1);
                String password = buffer.readCharSequence((int)fieldLength, CharsetUtil.US_ASCII).toString();
                ctx.fireChannelRead((Object)new SocksAuthRequest(this.username, password));
                break;
            }
            default: {
                throw new Error();
            }
        }
        ctx.pipeline().remove((ChannelHandler)this);
    }

    private static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_USERNAME,
        READ_PASSWORD;

    }
}

