/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socks;

import io.netty.contrib.handler.codec.socks.SocksAuthStatus;
import io.netty.contrib.handler.codec.socks.SocksResponse;
import io.netty.contrib.handler.codec.socks.SocksResponseType;
import io.netty.contrib.handler.codec.socks.SocksSubnegotiationVersion;
import io.netty5.buffer.api.Buffer;
import java.util.Objects;

public final class SocksAuthResponse
extends SocksResponse {
    private static final SocksSubnegotiationVersion SUBNEGOTIATION_VERSION = SocksSubnegotiationVersion.AUTH_PASSWORD;
    private final SocksAuthStatus authStatus;

    public SocksAuthResponse(SocksAuthStatus authStatus) {
        super(SocksResponseType.AUTH);
        Objects.requireNonNull(authStatus, "authStatus");
        this.authStatus = authStatus;
    }

    public SocksAuthStatus authStatus() {
        return this.authStatus;
    }

    @Override
    public void encodeAsBuffer(Buffer buffer) {
        buffer.writeByte(SUBNEGOTIATION_VERSION.byteValue());
        buffer.writeByte(this.authStatus.byteValue());
    }
}

