/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socks;

import io.netty.contrib.handler.codec.socks.SocksAuthResponse;
import io.netty.contrib.handler.codec.socks.SocksAuthStatus;
import io.netty.contrib.handler.codec.socks.SocksCommonUtils;
import io.netty.contrib.handler.codec.socks.SocksSubnegotiationVersion;
import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;

public class SocksAuthResponseDecoder
extends ByteToMessageDecoder {
    private State state = State.CHECK_PROTOCOL_VERSION;

    protected void decode(ChannelHandlerContext ctx, Buffer buffer) throws Exception {
        switch (this.state) {
            case CHECK_PROTOCOL_VERSION: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                if (buffer.readByte() != SocksSubnegotiationVersion.AUTH_PASSWORD.byteValue()) {
                    ctx.fireChannelRead((Object)SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE);
                    break;
                }
                this.state = State.READ_AUTH_RESPONSE;
            }
            case READ_AUTH_RESPONSE: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                SocksAuthStatus authStatus = SocksAuthStatus.valueOf(buffer.readByte());
                ctx.fireChannelRead((Object)new SocksAuthResponse(authStatus));
                break;
            }
            default: {
                throw new Error();
            }
        }
        ctx.pipeline().remove((ChannelHandler)this);
    }

    private static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_AUTH_RESPONSE;

    }
}

