/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socks;

import io.netty.contrib.handler.codec.socks.SocksAddressType;
import io.netty.contrib.handler.codec.socks.SocksCmdRequest;
import io.netty.contrib.handler.codec.socks.SocksCmdType;
import io.netty.contrib.handler.codec.socks.SocksCommonUtils;
import io.netty.contrib.handler.codec.socks.SocksProtocolVersion;
import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.util.CharsetUtil;
import io.netty5.util.NetUtil;

public class SocksCmdRequestDecoder
extends ByteToMessageDecoder {
    private State state = State.CHECK_PROTOCOL_VERSION;
    private SocksCmdType cmdType;
    private SocksAddressType addressType;

    protected void decode(ChannelHandlerContext ctx, Buffer buffer) throws Exception {
        block0 : switch (this.state) {
            case CHECK_PROTOCOL_VERSION: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                if (buffer.readByte() != SocksProtocolVersion.SOCKS5.byteValue()) {
                    ctx.fireChannelRead((Object)SocksCommonUtils.UNKNOWN_SOCKS_REQUEST);
                    break;
                }
                this.state = State.READ_CMD_HEADER;
            }
            case READ_CMD_HEADER: {
                if (buffer.readableBytes() < 3) {
                    return;
                }
                this.cmdType = SocksCmdType.valueOf(buffer.readByte());
                buffer.skipReadableBytes(1);
                this.addressType = SocksAddressType.valueOf(buffer.readByte());
                this.state = State.READ_CMD_ADDRESS;
            }
            case READ_CMD_ADDRESS: {
                switch (this.addressType) {
                    case IPv4: {
                        if (buffer.readableBytes() < 6) {
                            return;
                        }
                        String host = NetUtil.intToIpAddress((int)buffer.readInt());
                        int port = buffer.readUnsignedShort();
                        ctx.fireChannelRead((Object)new SocksCmdRequest(this.cmdType, this.addressType, host, port));
                        break block0;
                    }
                    case DOMAIN: {
                        if (buffer.readableBytes() < 1) {
                            return;
                        }
                        byte fieldLength = buffer.getByte(buffer.readerOffset());
                        if (buffer.readableBytes() < 3 + fieldLength) {
                            return;
                        }
                        buffer.skipReadableBytes(1);
                        String host = buffer.readCharSequence((int)fieldLength, CharsetUtil.US_ASCII).toString();
                        int port = buffer.readUnsignedShort();
                        ctx.fireChannelRead((Object)new SocksCmdRequest(this.cmdType, this.addressType, host, port));
                        break block0;
                    }
                    case IPv6: {
                        if (buffer.readableBytes() < 18) {
                            return;
                        }
                        byte[] bytes = new byte[16];
                        buffer.readBytes(bytes, 0, bytes.length);
                        String host = SocksCommonUtils.ipv6toStr(bytes);
                        int port = buffer.readUnsignedShort();
                        ctx.fireChannelRead((Object)new SocksCmdRequest(this.cmdType, this.addressType, host, port));
                        break block0;
                    }
                    case UNKNOWN: {
                        ctx.fireChannelRead((Object)SocksCommonUtils.UNKNOWN_SOCKS_REQUEST);
                        break block0;
                    }
                }
                throw new Error();
            }
            default: {
                throw new Error();
            }
        }
        ctx.pipeline().remove((ChannelHandler)this);
    }

    private static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_CMD_HEADER,
        READ_CMD_ADDRESS;

    }
}

