/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socksx;

import io.netty.contrib.handler.codec.socksx.SocksVersion;
import io.netty.contrib.handler.codec.socksx.v4.Socks4ServerDecoder;
import io.netty.contrib.handler.codec.socksx.v4.Socks4ServerEncoder;
import io.netty.contrib.handler.codec.socksx.v5.Socks5InitialRequestDecoder;
import io.netty.contrib.handler.codec.socksx.v5.Socks5ServerEncoder;
import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelPipeline;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.Objects;

public class SocksPortUnificationServerHandler
extends ByteToMessageDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SocksPortUnificationServerHandler.class);
    private final Socks5ServerEncoder socks5encoder;

    public SocksPortUnificationServerHandler() {
        this(Socks5ServerEncoder.DEFAULT);
    }

    public SocksPortUnificationServerHandler(Socks5ServerEncoder socks5encoder) {
        Objects.requireNonNull(socks5encoder, "socks5encoder");
        this.socks5encoder = socks5encoder;
    }

    protected void decode(ChannelHandlerContext ctx, Buffer in) throws Exception {
        int readerIndex = in.readerOffset();
        if (in.writerOffset() == readerIndex) {
            return;
        }
        ChannelPipeline p = ctx.pipeline();
        byte versionVal = in.getByte(readerIndex);
        SocksVersion version = SocksVersion.valueOf(versionVal);
        switch (version) {
            case SOCKS4a: {
                SocksPortUnificationServerHandler.logKnownVersion(ctx, version);
                p.addAfter(ctx.name(), null, (ChannelHandler)Socks4ServerEncoder.INSTANCE);
                p.addAfter(ctx.name(), null, (ChannelHandler)new Socks4ServerDecoder());
                break;
            }
            case SOCKS5: {
                SocksPortUnificationServerHandler.logKnownVersion(ctx, version);
                p.addAfter(ctx.name(), null, (ChannelHandler)this.socks5encoder);
                p.addAfter(ctx.name(), null, (ChannelHandler)new Socks5InitialRequestDecoder());
                break;
            }
            default: {
                SocksPortUnificationServerHandler.logUnknownVersion(ctx, versionVal);
                in.skipReadableBytes(in.readableBytes());
                ctx.close();
                return;
            }
        }
        p.remove((ChannelHandler)this);
    }

    private static void logKnownVersion(ChannelHandlerContext ctx, SocksVersion version) {
        logger.debug("{} Protocol version: {}({})", (Object)ctx.channel(), (Object)version);
    }

    private static void logUnknownVersion(ChannelHandlerContext ctx, byte versionVal) {
        if (logger.isDebugEnabled()) {
            logger.debug("{} Unknown protocol version: {}", (Object)ctx.channel(), (Object)(versionVal & 0xFF));
        }
    }
}

