/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socksx.v4;

import io.netty.contrib.handler.codec.socksx.v4.DefaultSocks4CommandResponse;
import io.netty.contrib.handler.codec.socksx.v4.Socks4CommandStatus;
import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.DecoderException;
import io.netty5.handler.codec.DecoderResult;
import io.netty5.util.NetUtil;

public class Socks4ClientDecoder
extends ByteToMessageDecoder {
    private State state = State.START;

    public Socks4ClientDecoder() {
        this.setSingleDecode(true);
    }

    protected void decode(ChannelHandlerContext ctx, Buffer in) throws Exception {
        try {
            switch (this.state) {
                case START: {
                    if (in.readableBytes() < 8) {
                        return;
                    }
                    int version = in.readUnsignedByte();
                    if (version != 0) {
                        throw new DecoderException("unsupported reply version: " + version + " (expected: 0)");
                    }
                    Socks4CommandStatus status = Socks4CommandStatus.valueOf(in.readByte());
                    int dstPort = in.readUnsignedShort();
                    String dstAddr = NetUtil.intToIpAddress((int)in.readInt());
                    ctx.fireChannelRead((Object)new DefaultSocks4CommandResponse(status, dstAddr, dstPort));
                    this.state = State.SUCCESS;
                }
                case SUCCESS: {
                    int readableBytes = this.actualReadableBytes();
                    if (readableBytes <= 0) break;
                    ctx.fireChannelRead((Object)in.readSplit(readableBytes));
                    break;
                }
                case FAILURE: {
                    in.skipReadableBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception e) {
            this.fail(ctx, e);
        }
    }

    private void fail(ChannelHandlerContext ctx, Exception cause) {
        if (!(cause instanceof DecoderException)) {
            cause = new DecoderException((Throwable)cause);
        }
        DefaultSocks4CommandResponse m = new DefaultSocks4CommandResponse(Socks4CommandStatus.REJECTED_OR_FAILED);
        m.setDecoderResult(DecoderResult.failure((Throwable)cause));
        ctx.fireChannelRead((Object)m);
        this.state = State.FAILURE;
    }

    private static enum State {
        START,
        SUCCESS,
        FAILURE;

    }
}

