/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socksx.v4;

import io.netty.contrib.handler.codec.socksx.v4.Socks4CommandRequest;
import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToByteEncoder;
import io.netty5.util.CharsetUtil;
import io.netty5.util.NetUtil;

public final class Socks4ClientEncoder
extends MessageToByteEncoder<Socks4CommandRequest> {
    public static final Socks4ClientEncoder INSTANCE = new Socks4ClientEncoder();
    private static final byte[] IPv4_DOMAIN_MARKER = new byte[]{0, 0, 0, 1};

    private Socks4ClientEncoder() {
    }

    protected Buffer allocateBuffer(ChannelHandlerContext ctx, Socks4CommandRequest msg) {
        return ctx.bufferAllocator().allocate(256);
    }

    protected void encode(ChannelHandlerContext ctx, Socks4CommandRequest msg, Buffer out) {
        out.writeByte(msg.version().byteValue());
        out.writeByte(msg.type().byteValue());
        out.writeShort((short)msg.dstPort());
        if (NetUtil.isValidIpV4Address((String)msg.dstAddr())) {
            out.writeBytes(NetUtil.createByteArrayFromIpAddressString((String)msg.dstAddr()));
            out.writeCharSequence((CharSequence)msg.userId(), CharsetUtil.US_ASCII);
            out.writeByte((byte)0);
        } else {
            out.writeBytes(IPv4_DOMAIN_MARKER);
            out.writeCharSequence((CharSequence)msg.userId(), CharsetUtil.US_ASCII);
            out.writeByte((byte)0);
            out.writeCharSequence((CharSequence)msg.dstAddr(), CharsetUtil.US_ASCII);
            out.writeByte((byte)0);
        }
    }

    public boolean isSharable() {
        return true;
    }
}

