/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socksx.v4;

import io.netty.contrib.handler.codec.socksx.v4.Socks4CommandResponse;
import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToByteEncoder;
import io.netty5.util.NetUtil;

public final class Socks4ServerEncoder
extends MessageToByteEncoder<Socks4CommandResponse> {
    public static final Socks4ServerEncoder INSTANCE = new Socks4ServerEncoder();
    private static final byte[] IPv4_HOSTNAME_ZEROED = new byte[]{0, 0, 0, 0};

    private Socks4ServerEncoder() {
    }

    protected Buffer allocateBuffer(ChannelHandlerContext ctx, Socks4CommandResponse msg) {
        return ctx.bufferAllocator().allocate(256);
    }

    protected void encode(ChannelHandlerContext ctx, Socks4CommandResponse msg, Buffer out) {
        out.writeByte((byte)0);
        out.writeByte(msg.status().byteValue());
        out.writeShort((short)msg.dstPort());
        out.writeBytes(msg.dstAddr() == null ? IPv4_HOSTNAME_ZEROED : NetUtil.createByteArrayFromIpAddressString((String)msg.dstAddr()));
    }

    public boolean isSharable() {
        return true;
    }
}

