/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socksx.v5;

import io.netty.contrib.handler.codec.socksx.v5.Socks5AddressType;
import io.netty5.buffer.api.Buffer;
import io.netty5.handler.codec.DecoderException;
import io.netty5.util.CharsetUtil;
import io.netty5.util.NetUtil;

public interface Socks5AddressDecoder {
    public static final Socks5AddressDecoder DEFAULT = new Socks5AddressDecoder(){
        private static final int IPv6_LEN = 16;

        @Override
        public String decodeAddress(Socks5AddressType addrType, Buffer in) {
            int readableBytes = in.readableBytes();
            if (addrType == Socks5AddressType.IPv4) {
                if (readableBytes < 4) {
                    return null;
                }
                return NetUtil.intToIpAddress((int)in.readInt());
            }
            if (addrType == Socks5AddressType.DOMAIN) {
                if (readableBytes < 1) {
                    return null;
                }
                int length = in.getUnsignedByte(in.readerOffset());
                if (readableBytes - 1 < length) {
                    return null;
                }
                in.skipReadableBytes(1);
                return in.readCharSequence(length, CharsetUtil.US_ASCII).toString();
            }
            if (addrType == Socks5AddressType.IPv6) {
                if (readableBytes < 16) {
                    return null;
                }
                byte[] tmp = new byte[16];
                in.readBytes(tmp, 0, tmp.length);
                return NetUtil.bytesToIpAddress((byte[])tmp);
            }
            throw new DecoderException("unsupported address type: " + (addrType.byteValue() & 0xFF));
        }
    };

    public String decodeAddress(Socks5AddressType var1, Buffer var2) throws Exception;
}

