/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socksx.v5;

import io.netty.contrib.handler.codec.socksx.SocksVersion;
import io.netty.contrib.handler.codec.socksx.v5.DefaultSocks5InitialResponse;
import io.netty.contrib.handler.codec.socksx.v5.Socks5AuthMethod;
import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.DecoderException;
import io.netty5.handler.codec.DecoderResult;

public class Socks5InitialResponseDecoder
extends ByteToMessageDecoder {
    private State state = State.INIT;

    protected void decode(ChannelHandlerContext ctx, Buffer in) throws Exception {
        try {
            switch (this.state) {
                case INIT: {
                    if (in.readableBytes() < 2) {
                        return;
                    }
                    byte version = in.readByte();
                    if (version != SocksVersion.SOCKS5.byteValue()) {
                        throw new DecoderException("unsupported version: " + version + " (expected: " + SocksVersion.SOCKS5.byteValue() + ")");
                    }
                    Socks5AuthMethod authMethod = Socks5AuthMethod.valueOf(in.readByte());
                    ctx.fireChannelRead((Object)new DefaultSocks5InitialResponse(authMethod));
                    this.state = State.SUCCESS;
                }
                case SUCCESS: {
                    int readableBytes = this.actualReadableBytes();
                    if (readableBytes <= 0) break;
                    ctx.fireChannelRead((Object)in.readSplit(readableBytes));
                    break;
                }
                case FAILURE: {
                    in.skipReadableBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception e) {
            this.fail(ctx, e);
        }
    }

    private void fail(ChannelHandlerContext ctx, Exception cause) {
        if (!(cause instanceof DecoderException)) {
            cause = new DecoderException((Throwable)cause);
        }
        this.state = State.FAILURE;
        DefaultSocks5InitialResponse m = new DefaultSocks5InitialResponse(Socks5AuthMethod.UNACCEPTED);
        m.setDecoderResult(DecoderResult.failure((Throwable)cause));
        ctx.fireChannelRead((Object)m);
    }

    private static enum State {
        INIT,
        SUCCESS,
        FAILURE;

    }
}

