/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socksx.v5;

import io.netty.contrib.handler.codec.socksx.v5.DefaultSocks5PasswordAuthRequest;
import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.DecoderException;
import io.netty5.handler.codec.DecoderResult;
import io.netty5.util.CharsetUtil;

public class Socks5PasswordAuthRequestDecoder
extends ByteToMessageDecoder {
    private State state = State.INIT;

    protected void decode(ChannelHandlerContext ctx, Buffer in) throws Exception {
        try {
            switch (this.state) {
                case INIT: {
                    if (in.readableBytes() < 3) {
                        return;
                    }
                    int startOffset = in.readerOffset();
                    byte version = in.getByte(startOffset);
                    if (version != 1) {
                        throw new DecoderException("unsupported subnegotiation version: " + version + " (expected: 1)");
                    }
                    int usernameLength = in.getUnsignedByte(startOffset + 1);
                    int passwordLength = in.getUnsignedByte(startOffset + 2 + usernameLength);
                    int totalLength = usernameLength + passwordLength + 3;
                    if (in.readableBytes() < totalLength) {
                        return;
                    }
                    in.skipReadableBytes(2);
                    String username = in.readCharSequence(usernameLength, CharsetUtil.US_ASCII).toString();
                    in.skipReadableBytes(1);
                    String password = in.readCharSequence(passwordLength, CharsetUtil.US_ASCII).toString();
                    ctx.fireChannelRead((Object)new DefaultSocks5PasswordAuthRequest(username, password));
                    this.state = State.SUCCESS;
                }
                case SUCCESS: {
                    int readableBytes = this.actualReadableBytes();
                    if (readableBytes <= 0) break;
                    ctx.fireChannelRead((Object)in.readSplit(readableBytes));
                    break;
                }
                case FAILURE: {
                    in.skipReadableBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception e) {
            this.fail(ctx, e);
        }
    }

    private void fail(ChannelHandlerContext ctx, Exception cause) {
        if (!(cause instanceof DecoderException)) {
            cause = new DecoderException((Throwable)cause);
        }
        this.state = State.FAILURE;
        DefaultSocks5PasswordAuthRequest m = new DefaultSocks5PasswordAuthRequest("", "");
        m.setDecoderResult(DecoderResult.failure((Throwable)cause));
        ctx.fireChannelRead((Object)m);
    }

    private static enum State {
        INIT,
        SUCCESS,
        FAILURE;

    }
}

