/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.proxy;

import io.netty.contrib.handler.proxy.ProxyConnectException;
import io.netty.contrib.handler.proxy.ProxyConnectionEvent;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.PendingWriteQueue;
import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.concurrent.DefaultPromise;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.ImmediateEventExecutor;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ConnectionPendingException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class ProxyHandler
implements ChannelHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ProxyHandler.class);
    private static final long DEFAULT_CONNECT_TIMEOUT_MILLIS = 10000L;
    static final String AUTH_NONE = "none";
    private final SocketAddress proxyAddress;
    private volatile SocketAddress destinationAddress;
    private volatile long connectTimeoutMillis = 10000L;
    private volatile ChannelHandlerContext ctx;
    private PendingWriteQueue pendingWrites;
    private boolean finished;
    private boolean suppressChannelReadComplete;
    private boolean flushedPrematurely;
    private final Promise<Channel> connectPromise = new LazyPromise();
    private Future<?> connectTimeoutFuture;
    private final FutureListener<Void> writeListener = future -> {
        if (future.isFailed()) {
            this.setConnectFailure(future.cause());
        }
    };

    protected ProxyHandler(SocketAddress proxyAddress) {
        Objects.requireNonNull(proxyAddress, "proxyAddress");
        this.proxyAddress = proxyAddress;
    }

    public abstract String protocol();

    public abstract String authScheme();

    public final <T extends SocketAddress> T proxyAddress() {
        return (T)this.proxyAddress;
    }

    public final <T extends SocketAddress> T destinationAddress() {
        return (T)this.destinationAddress;
    }

    public final boolean isConnected() {
        return this.connectPromise.isSuccess();
    }

    public final Future<Channel> connectFuture() {
        return this.connectPromise.asFuture();
    }

    public final long connectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public final void setConnectTimeoutMillis(long connectTimeoutMillis) {
        if (connectTimeoutMillis <= 0L) {
            connectTimeoutMillis = 0L;
        }
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public final void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        this.addCodec(ctx);
        if (ctx.channel().isActive()) {
            this.sendInitialMessage(ctx);
        }
    }

    protected abstract void addCodec(ChannelHandlerContext var1) throws Exception;

    protected abstract void removeEncoder(ChannelHandlerContext var1) throws Exception;

    protected abstract void removeDecoder(ChannelHandlerContext var1) throws Exception;

    public final Future<Void> connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress) {
        if (this.destinationAddress != null) {
            return ctx.newFailedFuture((Throwable)new ConnectionPendingException());
        }
        this.destinationAddress = remoteAddress;
        return ctx.connect(this.proxyAddress, localAddress);
    }

    public final void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.sendInitialMessage(ctx);
        ctx.fireChannelActive();
    }

    private void sendInitialMessage(ChannelHandlerContext ctx) throws Exception {
        Object initialMessage;
        long connectTimeoutMillis = this.connectTimeoutMillis;
        if (connectTimeoutMillis > 0L) {
            this.connectTimeoutFuture = ctx.executor().schedule(() -> {
                if (!this.connectPromise.isDone()) {
                    this.setConnectFailure(new ProxyConnectException(this.exceptionMessage("timeout")));
                }
            }, connectTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        if ((initialMessage = this.newInitialMessage(ctx)) != null) {
            this.sendToProxyServer(initialMessage);
        }
        ProxyHandler.readIfNeeded(ctx);
    }

    protected abstract Object newInitialMessage(ChannelHandlerContext var1) throws Exception;

    protected final void sendToProxyServer(Object msg) {
        this.ctx.writeAndFlush(msg).addListener(this.writeListener);
    }

    public final void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.finished) {
            ctx.fireChannelInactive();
        } else {
            this.setConnectFailure(new ProxyConnectException(this.exceptionMessage("disconnected")));
        }
    }

    public final void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.finished) {
            ctx.fireChannelExceptionCaught(cause);
        } else {
            this.setConnectFailure(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.finished) {
            this.suppressChannelReadComplete = false;
            ctx.fireChannelRead(msg);
        } else {
            this.suppressChannelReadComplete = true;
            Throwable cause = null;
            try {
                boolean done = this.handleResponse(ctx, msg);
                if (done) {
                    this.setConnectSuccess(ctx);
                }
            }
            catch (Throwable t) {
                cause = t;
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
                if (cause != null) {
                    this.setConnectFailure(cause);
                }
            }
        }
    }

    protected abstract boolean handleResponse(ChannelHandlerContext var1, Object var2) throws Exception;

    private void setConnectSuccess(ChannelHandlerContext ctx) {
        this.finished = true;
        this.cancelConnectTimeoutFuture();
        if (!this.connectPromise.isDone()) {
            boolean removedCodec = true;
            removedCodec &= this.safeRemoveEncoder();
            ctx.fireChannelInboundEvent((Object)new ProxyConnectionEvent(this.protocol(), this.authScheme(), this.proxyAddress, this.destinationAddress));
            if (removedCodec &= this.safeRemoveDecoder()) {
                this.writePendingWrites(ctx);
                if (this.flushedPrematurely) {
                    ctx.flush();
                }
                this.connectPromise.trySuccess((Object)ctx.channel());
            } else {
                ProxyConnectException cause = new ProxyConnectException("failed to remove all codec handlers added by the proxy handler; bug?");
                this.failPendingWritesAndClose(cause);
            }
        }
    }

    private boolean safeRemoveDecoder() {
        try {
            this.removeDecoder(this.ctx);
            return true;
        }
        catch (Exception e) {
            logger.warn("Failed to remove proxy decoders:", (Throwable)e);
            return false;
        }
    }

    private boolean safeRemoveEncoder() {
        try {
            this.removeEncoder(this.ctx);
            return true;
        }
        catch (Exception e) {
            logger.warn("Failed to remove proxy encoders:", (Throwable)e);
            return false;
        }
    }

    private void setConnectFailure(Throwable cause) {
        this.finished = true;
        this.cancelConnectTimeoutFuture();
        if (!this.connectPromise.isDone()) {
            if (!(cause instanceof ProxyConnectException)) {
                cause = new ProxyConnectException(this.exceptionMessage(cause.toString()), cause);
            }
            this.safeRemoveDecoder();
            this.safeRemoveEncoder();
            this.failPendingWritesAndClose(cause);
        }
    }

    private void failPendingWritesAndClose(Throwable cause) {
        this.failPendingWrites(cause);
        this.connectPromise.tryFailure(cause);
        this.ctx.fireChannelExceptionCaught(cause);
        this.ctx.close();
    }

    private void cancelConnectTimeoutFuture() {
        if (this.connectTimeoutFuture != null) {
            this.connectTimeoutFuture.cancel();
            this.connectTimeoutFuture = null;
        }
    }

    protected final String exceptionMessage(String msg) {
        if (msg == null) {
            msg = "";
        }
        StringBuilder buf = new StringBuilder(128 + msg.length()).append(this.protocol()).append(", ").append(this.authScheme()).append(", ").append(this.proxyAddress).append(" => ").append(this.destinationAddress);
        if (!msg.isEmpty()) {
            buf.append(", ").append(msg);
        }
        return buf.toString();
    }

    public final void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.suppressChannelReadComplete) {
            this.suppressChannelReadComplete = false;
            ProxyHandler.readIfNeeded(ctx);
        } else {
            ctx.fireChannelReadComplete();
        }
    }

    public final Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        if (this.finished) {
            this.writePendingWrites(ctx);
            return ctx.write(msg);
        }
        Promise promise = ctx.newPromise();
        this.addPendingWrite(ctx, msg, (Promise<Void>)promise);
        return promise.asFuture();
    }

    public final void flush(ChannelHandlerContext ctx) {
        if (this.finished) {
            this.writePendingWrites(ctx);
            ctx.flush();
        } else {
            this.flushedPrematurely = true;
        }
    }

    private static void readIfNeeded(ChannelHandlerContext ctx) {
        if (!ctx.channel().config().isAutoRead()) {
            ctx.read();
        }
    }

    private void writePendingWrites(ChannelHandlerContext ctx) {
        if (this.pendingWrites != null) {
            PendingWriteQueue queue = this.pendingWrites;
            this.pendingWrites = null;
            queue.removeAndTransferAll(arg_0 -> ((ChannelHandlerContext)ctx).write(arg_0));
        }
    }

    private void failPendingWrites(Throwable cause) {
        if (this.pendingWrites != null) {
            this.pendingWrites.removeAndFailAll(cause);
            this.pendingWrites = null;
        }
    }

    private void addPendingWrite(ChannelHandlerContext ctx, Object msg, Promise<Void> promise) {
        PendingWriteQueue pendingWrites = this.pendingWrites;
        if (pendingWrites == null) {
            this.pendingWrites = pendingWrites = new PendingWriteQueue(ctx.executor(), ctx.channel().config().getMessageSizeEstimator().newHandle());
        }
        pendingWrites.add(msg, promise);
    }

    private final class LazyPromise
    extends DefaultPromise<Channel> {
        LazyPromise() {
            super((EventExecutor)ImmediateEventExecutor.INSTANCE);
        }

        protected void checkDeadLock() {
            if (ProxyHandler.this.ctx == null) {
                return;
            }
            this.checkDeadLock(ProxyHandler.this.ctx.executor());
        }
    }
}

