/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.bhttp;

import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.incubator.codec.bhttp.BinaryHttpHeaders;
import io.netty.incubator.codec.bhttp.BinaryHttpRequest;
import io.netty.incubator.codec.bhttp.BinaryHttpResponse;
import io.netty.incubator.codec.bhttp.DefaultBinaryHttpRequest;
import io.netty.incubator.codec.bhttp.DefaultBinaryHttpResponse;
import io.netty.incubator.codec.bhttp.DefaultFullBinaryHttpRequest;
import io.netty.incubator.codec.bhttp.DefaultFullBinaryHttpResponse;
import io.netty.incubator.codec.bhttp.FullBinaryHttpRequest;
import io.netty.incubator.codec.bhttp.FullBinaryHttpResponse;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.Map;

public final class BinaryHttpConverter {
    private BinaryHttpConverter() {
    }

    public static BinaryHttpRequest convert(HttpRequest request, String scheme, String authority) {
        if (request instanceof FullBinaryHttpRequest) {
            return BinaryHttpConverter.convert((FullHttpRequest)request, scheme, authority);
        }
        BinaryHttpHeaders headers = BinaryHttpConverter.copyAndSanitize(request.headers());
        DefaultBinaryHttpRequest binaryHttpRequest = new DefaultBinaryHttpRequest(request.protocolVersion(), request.method(), scheme, authority, request.uri(), headers);
        binaryHttpRequest.setDecoderResult(request.decoderResult());
        return binaryHttpRequest;
    }

    public static FullBinaryHttpRequest convert(FullHttpRequest request, String scheme, String authority) {
        BinaryHttpHeaders headers = BinaryHttpConverter.copyAndSanitize(request.headers());
        BinaryHttpHeaders trailers = BinaryHttpConverter.copyAndSanitize(request.trailingHeaders());
        DefaultFullBinaryHttpRequest binaryHttpRequest = new DefaultFullBinaryHttpRequest(request.protocolVersion(), request.method(), scheme, authority, request.uri(), request.content().retain(), headers, trailers);
        binaryHttpRequest.setDecoderResult(request.decoderResult());
        request.release();
        return binaryHttpRequest;
    }

    public static BinaryHttpResponse convert(HttpResponse response) {
        if (response instanceof FullBinaryHttpRequest) {
            return BinaryHttpConverter.convert((FullHttpResponse)response);
        }
        BinaryHttpHeaders headers = BinaryHttpConverter.copyAndSanitize(response.headers());
        DefaultBinaryHttpResponse binaryHttpResponse = new DefaultBinaryHttpResponse(response.protocolVersion(), response.status(), headers);
        binaryHttpResponse.setDecoderResult(response.decoderResult());
        return binaryHttpResponse;
    }

    public static FullBinaryHttpResponse convert(FullHttpResponse response) {
        BinaryHttpHeaders headers = BinaryHttpConverter.copyAndSanitize(response.headers());
        BinaryHttpHeaders trailers = BinaryHttpConverter.copyAndSanitize(response.trailingHeaders());
        DefaultFullBinaryHttpResponse binaryHttpResponse = new DefaultFullBinaryHttpResponse(response.protocolVersion(), response.status(), response.content().retain(), (HttpHeaders)headers, (HttpHeaders)trailers);
        binaryHttpResponse.setDecoderResult(response.decoderResult());
        response.release();
        return binaryHttpResponse;
    }

    public static LastHttpContent convert(LastHttpContent content) {
        BinaryHttpHeaders trailers = BinaryHttpConverter.copyAndSanitize(content.trailingHeaders());
        DefaultLastHttpContent binaryContent = new DefaultLastHttpContent(content.content().retain(), (HttpHeaders)trailers);
        content.release();
        return binaryContent;
    }

    private static BinaryHttpHeaders copyAndSanitize(HttpHeaders headers) {
        BinaryHttpHeaders binaryHttpHeaders = BinaryHttpHeaders.newHeaders(true);
        if (headers.isEmpty()) {
            return binaryHttpHeaders;
        }
        Iterator it = headers.iteratorCharSequence();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            CharSequence name = (CharSequence)entry.getKey();
            if (name instanceof AsciiString) {
                binaryHttpHeaders.add((CharSequence)((AsciiString)name).toLowerCase(), entry.getValue());
                continue;
            }
            if (name instanceof String) {
                binaryHttpHeaders.add(((String)name).toLowerCase(), entry.getValue());
                continue;
            }
            if (BinaryHttpConverter.isAnyUpperCase(name)) {
                binaryHttpHeaders.add((CharSequence)new AsciiString(name).toLowerCase(), entry.getValue());
                continue;
            }
            binaryHttpHeaders.add(name, entry.getValue());
        }
        return binaryHttpHeaders;
    }

    private static boolean isAnyUpperCase(CharSequence name) {
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            if (!AsciiString.isUpperCase((char)name.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

