/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.http3;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.incubator.codec.http3.Http3CodecUtils;
import io.netty.incubator.codec.http3.Http3ConnectionHandler;
import io.netty.incubator.codec.http3.Http3RequestStreamInitializer;
import io.netty.incubator.codec.http3.QpackAttributes;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicClientCodecBuilder;
import io.netty.incubator.codec.quic.QuicCodecBuilder;
import io.netty.incubator.codec.quic.QuicServerCodecBuilder;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.incubator.codec.quic.QuicStreamChannelBootstrap;
import io.netty.incubator.codec.quic.QuicStreamType;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;

public final class Http3 {
    private static final String[] H3_PROTOS = new String[]{"h3-29", "h3-30", "h3-31", "h3-32", "h3"};
    private static final AttributeKey<QuicStreamChannel> HTTP3_CONTROL_STREAM_KEY = AttributeKey.valueOf(Http3.class, (String)"HTTP3ControlStream");
    private static final AttributeKey<QpackAttributes> QPACK_ATTRIBUTES_KEY = AttributeKey.valueOf(Http3.class, (String)"QpackAttributes");
    public static final int MIN_INITIAL_MAX_STREAMS_UNIDIRECTIONAL = 3;
    public static final int MIN_INITIAL_MAX_STREAM_DATA_UNIDIRECTIONAL = 1024;

    private Http3() {
    }

    public static QuicStreamChannel getLocalControlStream(Channel channel) {
        return (QuicStreamChannel)channel.attr(HTTP3_CONTROL_STREAM_KEY).get();
    }

    static long maxPushIdReceived(QuicChannel channel) {
        Http3ConnectionHandler connectionHandler = Http3CodecUtils.getConnectionHandlerOrClose(channel);
        if (connectionHandler == null) {
            throw new IllegalStateException("Connection handler not found.");
        }
        return connectionHandler.localControlStreamHandler.maxPushIdReceived();
    }

    static void setLocalControlStream(Channel channel, QuicStreamChannel controlStreamChannel) {
        channel.attr(HTTP3_CONTROL_STREAM_KEY).set((Object)controlStreamChannel);
    }

    static QpackAttributes getQpackAttributes(Channel channel) {
        return (QpackAttributes)channel.attr(QPACK_ATTRIBUTES_KEY).get();
    }

    static void setQpackAttributes(Channel channel, QpackAttributes attributes) {
        channel.attr(QPACK_ATTRIBUTES_KEY).set((Object)attributes);
    }

    public static Future<QuicStreamChannel> newRequestStream(QuicChannel channel, ChannelHandler handler) {
        return channel.createStream(QuicStreamType.BIDIRECTIONAL, (ChannelHandler)Http3.requestStreamInitializer(handler));
    }

    public static QuicStreamChannelBootstrap newRequestStreamBootstrap(QuicChannel channel, ChannelHandler handler) {
        return channel.newStreamBootstrap().handler((ChannelHandler)Http3.requestStreamInitializer(handler)).type(QuicStreamType.BIDIRECTIONAL);
    }

    public static String[] supportedApplicationProtocols() {
        return (String[])H3_PROTOS.clone();
    }

    public static QuicServerCodecBuilder newQuicServerCodecBuilder() {
        return Http3.configure(new QuicServerCodecBuilder());
    }

    public static QuicClientCodecBuilder newQuicClientCodecBuilder() {
        return Http3.configure(new QuicClientCodecBuilder());
    }

    private static <T extends QuicCodecBuilder<T>> T configure(T builder) {
        return (T)builder.initialMaxStreamsUnidirectional(3L).initialMaxStreamDataUnidirectional(1024L);
    }

    private static Http3RequestStreamInitializer requestStreamInitializer(final ChannelHandler handler) {
        if (handler instanceof Http3RequestStreamInitializer) {
            return (Http3RequestStreamInitializer)handler;
        }
        return new Http3RequestStreamInitializer(){

            @Override
            protected void initRequestStream(QuicStreamChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{handler});
            }
        };
    }
}

