/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.http3;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.incubator.codec.http3.DefaultHttp3SettingsFrame;
import io.netty.incubator.codec.http3.Http3CodecUtils;
import io.netty.incubator.codec.http3.Http3ControlStreamFrame;
import io.netty.incubator.codec.http3.Http3ErrorCode;
import io.netty.incubator.codec.http3.Http3Exception;
import io.netty.incubator.codec.http3.Http3FrameTypeDuplexValidationHandler;
import io.netty.incubator.codec.http3.Http3GoAwayFrame;
import io.netty.incubator.codec.http3.Http3MaxPushIdFrame;
import io.netty.incubator.codec.http3.Http3SettingsFrame;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;

final class Http3ControlStreamOutboundHandler
extends Http3FrameTypeDuplexValidationHandler<Http3ControlStreamFrame> {
    private final boolean server;
    private final Http3SettingsFrame localSettings;
    private final ChannelHandler codec;
    private Long sentMaxPushId;
    private Long sendGoAwayId;

    Http3ControlStreamOutboundHandler(boolean server, Http3SettingsFrame localSettings, ChannelHandler codec) {
        super(Http3ControlStreamFrame.class);
        this.server = server;
        this.localSettings = (Http3SettingsFrame)ObjectUtil.checkNotNull((Object)localSettings, (String)"localSettings");
        this.codec = (ChannelHandler)ObjectUtil.checkNotNull((Object)codec, (String)"codec");
    }

    Http3SettingsFrame localSettings() {
        return this.localSettings;
    }

    Long sentMaxPushId() {
        return this.sentMaxPushId;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ByteBuf buffer = ctx.alloc().buffer(8);
        Http3CodecUtils.writeVariableLengthInteger(buffer, 0L);
        ctx.write((Object)buffer);
        ctx.pipeline().addFirst(new ChannelHandler[]{this.codec});
        Http3CodecUtils.closeOnFailure(ctx.writeAndFlush((Object)DefaultHttp3SettingsFrame.copyOf(this.localSettings)));
        ctx.fireChannelActive();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof ChannelInputShutdownEvent) {
            Http3CodecUtils.criticalStreamClosed(ctx);
        }
        ctx.fireUserEventTriggered(evt);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        Http3CodecUtils.criticalStreamClosed(ctx);
        ctx.fireChannelInactive();
    }

    @Override
    void write(ChannelHandlerContext ctx, Http3ControlStreamFrame msg, ChannelPromise promise) {
        if (msg instanceof Http3MaxPushIdFrame && !this.handleHttp3MaxPushIdFrame(promise, (Http3MaxPushIdFrame)msg)) {
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        if (msg instanceof Http3GoAwayFrame && !this.handleHttp3GoAwayFrame(promise, (Http3GoAwayFrame)msg)) {
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        ctx.write((Object)msg, promise);
    }

    private boolean handleHttp3MaxPushIdFrame(ChannelPromise promise, Http3MaxPushIdFrame maxPushIdFrame) {
        long id = maxPushIdFrame.id();
        if (this.sentMaxPushId != null && id < this.sentMaxPushId) {
            promise.setFailure((Throwable)new Http3Exception(Http3ErrorCode.H3_ID_ERROR, "MAX_PUSH_ID reduced limit."));
            return false;
        }
        this.sentMaxPushId = maxPushIdFrame.id();
        return true;
    }

    private boolean handleHttp3GoAwayFrame(ChannelPromise promise, Http3GoAwayFrame goAwayFrame) {
        long id = goAwayFrame.id();
        if (this.server && id % 4L != 0L) {
            promise.setFailure((Throwable)new Http3Exception(Http3ErrorCode.H3_ID_ERROR, "GOAWAY id not valid : " + id));
            return false;
        }
        if (this.sendGoAwayId != null && id > this.sendGoAwayId) {
            promise.setFailure((Throwable)new Http3Exception(Http3ErrorCode.H3_ID_ERROR, "GOAWAY id is bigger then the last sent: " + id + " > " + this.sendGoAwayId));
            return false;
        }
        this.sendGoAwayId = id;
        return true;
    }

    public boolean isSharable() {
        return false;
    }
}

