/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.http3;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.incubator.codec.http3.DefaultHttp3DataFrame;
import io.netty.incubator.codec.http3.Http3;
import io.netty.incubator.codec.http3.Http3DataFrame;
import io.netty.incubator.codec.http3.Http3Exception;
import io.netty.incubator.codec.http3.Http3HeadersFrame;
import io.netty.incubator.codec.http3.Http3UnknownFrame;
import io.netty.incubator.codec.quic.QuicException;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class Http3RequestStreamInboundHandler
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http3RequestStreamInboundHandler.class);
    private static final Http3DataFrame EMPTY = new DefaultHttp3DataFrame(Unpooled.EMPTY_BUFFER);
    private boolean lastFrameDetected;
    private boolean firstFrameReceived;

    public final boolean isSharable() {
        return false;
    }

    public final void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.firstFrameReceived = true;
        boolean inputShutdown = ((QuicStreamChannel)ctx.channel()).isInputShutdown();
        if (msg instanceof Http3UnknownFrame) {
            this.channelRead(ctx, (Http3UnknownFrame)msg);
            if (inputShutdown) {
                this.notifyLast(ctx);
            }
        } else {
            if (inputShutdown) {
                this.lastFrameDetected = true;
            }
            if (msg instanceof Http3HeadersFrame) {
                this.channelRead(ctx, (Http3HeadersFrame)msg, inputShutdown);
            }
            if (msg instanceof Http3DataFrame) {
                this.channelRead(ctx, (Http3DataFrame)msg, inputShutdown);
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == ChannelInputShutdownEvent.INSTANCE) {
            this.notifyLast(ctx);
        }
        ctx.fireUserEventTriggered(evt);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof QuicException) {
            this.handleQuicException(ctx, (QuicException)cause);
        } else if (cause instanceof Http3Exception) {
            this.handleHttp3Exception(ctx, (Http3Exception)cause);
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }

    private void notifyLast(ChannelHandlerContext ctx) throws Exception {
        if (!this.lastFrameDetected && this.firstFrameReceived) {
            this.lastFrameDetected = true;
            this.channelRead(ctx, EMPTY, true);
        }
    }

    protected abstract void channelRead(ChannelHandlerContext var1, Http3HeadersFrame var2, boolean var3) throws Exception;

    protected abstract void channelRead(ChannelHandlerContext var1, Http3DataFrame var2, boolean var3) throws Exception;

    protected void channelRead(ChannelHandlerContext ctx, Http3UnknownFrame frame) {
        frame.release();
    }

    protected void handleQuicException(ChannelHandlerContext ctx, QuicException exception) {
        logger.debug("Caught QuicException on channel {}", (Object)ctx.channel(), (Object)exception);
    }

    protected void handleHttp3Exception(ChannelHandlerContext ctx, Http3Exception exception) {
        logger.error("Caught Http3Exception on channel {}", (Object)ctx.channel(), (Object)exception);
    }

    protected final QuicStreamChannel controlStream(ChannelHandlerContext ctx) {
        return Http3.getLocalControlStream(ctx.channel().parent());
    }
}

